/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.util.Iterator;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.yasson.internal.ClassParser;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonbAnnotatedElement;
import org.eclipse.yasson.internal.model.customization.ClassCustomization;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;

public class MappingContext {
    private final JsonbContext jsonbContext;
    private final ConcurrentHashMap<Class<?>, ClassModel> classes = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, ContainerSerializerProvider> serializers = new ConcurrentHashMap();
    private final ClassParser classParser;

    public MappingContext(JsonbContext jsonbContext) {
        Objects.requireNonNull(jsonbContext);
        this.jsonbContext = jsonbContext;
        this.classParser = new ClassParser(jsonbContext);
    }

    public ClassModel getOrCreateClassModel(Class<?> clazz) {
        ClassModel classModel = this.classes.get(clazz);
        if (classModel != null) {
            return classModel;
        }
        Stack newClassModels = new Stack();
        for (Class<?> classToParse = clazz; classToParse != Object.class && classToParse != null; classToParse = classToParse.getSuperclass()) {
            newClassModels.push(classToParse);
        }
        if (clazz == Object.class) {
            this.classes.computeIfAbsent(clazz, c -> new ClassModel((Class<?>)c, null, null, null));
            return this.classes.get(clazz);
        }
        ClassModel parentClassModel = null;
        while (!newClassModels.empty()) {
            Class toParse = (Class)newClassModels.pop();
            parentClassModel = this.classes.computeIfAbsent(toParse, new ParseClassModelFunction(parentClassModel, this.classParser, this.jsonbContext));
        }
        return this.classes.get(clazz);
    }

    public Iterator<ClassModel> classModelIterator(final Class<?> clazz) {
        return new Iterator<ClassModel>(){
            private Class<?> next;
            {
                this.next = clazz;
            }

            @Override
            public boolean hasNext() {
                return this.next != Object.class;
            }

            @Override
            public ClassModel next() {
                ClassModel result = (ClassModel)MappingContext.this.classes.get(this.next);
                this.next = this.next.getSuperclass();
                return result;
            }
        };
    }

    public ClassModel getClassModel(Class<?> clazz) {
        return this.classes.get(clazz);
    }

    public ContainerSerializerProvider getSerializerProvider(Class<?> clazz) {
        return this.serializers.get(clazz);
    }

    public void addSerializerProvider(Class<?> clazz, ContainerSerializerProvider serializerProvider) {
        this.serializers.putIfAbsent(clazz, serializerProvider);
    }

    private static class ParseClassModelFunction
    implements Function<Class, ClassModel> {
        private ClassModel parentClassModel;
        private ClassParser classParser;
        private JsonbContext jsonbContext;

        public ParseClassModelFunction(ClassModel parentClassModel, ClassParser classParser, JsonbContext jsonbContext) {
            this.parentClassModel = parentClassModel;
            this.classParser = classParser;
            this.jsonbContext = jsonbContext;
        }

        @Override
        public ClassModel apply(Class aClass) {
            JsonbAnnotatedElement<Class<?>> clsElement = this.jsonbContext.getAnnotationIntrospector().collectAnnotations(aClass);
            ClassCustomization customization = this.jsonbContext.getAnnotationIntrospector().introspectCustomization(clsElement);
            ClassModel newClassModel = new ClassModel(aClass, customization, this.parentClassModel, this.jsonbContext.getConfigProperties().getPropertyNamingStrategy());
            this.classParser.parseProperties(newClassModel, clsElement);
            return newClassModel;
        }
    }
}

