/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.enterprise.iiop.impl.NamingClusterInfoImpl;
import org.glassfish.enterprise.iiop.impl.RoundRobinPolicy;
import org.glassfish.logging.annotation.LogMessageInfo;

public class GroupInfoServiceObserverImpl
implements GroupInfoServiceObserver {
    @LogMessageInfo(message="Problem with membership change notification. Exception occurred : {0}", cause="check server.log for details", action="check network configuration and cluster setup")
    public static final String GROUPINFOSERVICE_MEMBERSHIP_NOTIFICATION_PROBLEM = "AS-ORB-00003";
    private GroupInfoService gis;
    private RoundRobinPolicy rr;

    public GroupInfoServiceObserverImpl(GroupInfoService gis, RoundRobinPolicy rr) {
        this.gis = gis;
        this.rr = rr;
    }

    public void forceMembershipChange() {
        this.doMembershipChange();
        if (NamingClusterInfoImpl.logger.isLoggable(Level.FINE)) {
            NamingClusterInfoImpl.logger.log(Level.FINE, "GroupInfoServiceObserverImpl.forceMembershipChange called");
        }
    }

    public void membershipChange() {
        this.doMembershipChange();
        if (NamingClusterInfoImpl.logger.isLoggable(Level.FINE)) {
            NamingClusterInfoImpl.logger.log(Level.FINE, "GroupInfoServiceObserverImpl.membershipChange called");
        }
    }

    private void doMembershipChange() {
        try {
            List instanceInfoList = this.gis.getClusterInstanceInfo(null, this.rr.getHostPortList());
            if (instanceInfoList != null && instanceInfoList.size() > 0) {
                this.rr.setClusterInstanceInfo(instanceInfoList);
            }
        }
        catch (Exception e) {
            NamingClusterInfoImpl.logger.log(Level.SEVERE, GROUPINFOSERVICE_MEMBERSHIP_NOTIFICATION_PROBLEM, e);
            NamingClusterInfoImpl.logger.log(Level.SEVERE, "", e);
        }
    }
}

