/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.injection.AbstractResourceInjection;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.security.GetAccessibleCopyOfMember;
import org.jboss.weld.util.reflection.Reflections;

class SetterResourceInjection<T, X>
extends AbstractResourceInjection<T> {
    private final Method accessibleMethod;

    SetterResourceInjection(ParameterInjectionPoint<T, X> injectionPoint, ResourceReferenceFactory<T> factory) {
        super(factory);
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)injectionPoint.getAnnotated().getDeclaringCallable();
        this.accessibleMethod = AccessController.doPrivileged(new GetAccessibleCopyOfMember<Method>(annotatedMethod.getJavaMember()));
    }

    @Override
    protected void injectMember(Object declaringInstance, Object reference) {
        try {
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && instanceToInject instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).getTargetInstance();
            }
            this.accessibleMethod.invoke(instanceToInject, reference);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    Method getMember() {
        return this.accessibleMethod;
    }
}

