/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.tests.security.permissions;

import com.sun.ts.lib.tests.security.permissions.CTSPropertyPermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

final class CTSPropertyPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient Map perms = new HashMap(32);

    @Override
    public void add(Permission permission) {
        if (permission == null) {
            throw new IllegalArgumentException("failed trying to add null permission");
        }
        if (!(permission instanceof CTSPropertyPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("can't add perm to (READONLY) CTSPropertyPermission");
        }
        CTSPropertyPermission propPerm = (CTSPropertyPermission)permission;
        String permName = propPerm.getName();
        CTSPropertyPermission thePerm = (CTSPropertyPermission)this.perms.get(permName);
        if (thePerm != null) {
            if (thePerm.getMask() != propPerm.getMask()) {
                String actions = CTSPropertyPermission.getActions(thePerm.getMask() | propPerm.getMask());
                this.perms.put(permName, new CTSPropertyPermission(permName, actions));
            }
        } else {
            this.perms.put(permName, permission);
        }
    }

    @Override
    public boolean implies(Permission permission) {
        CTSPropertyPermission that = (CTSPropertyPermission)permission;
        if (!(permission instanceof CTSPropertyPermission)) {
            System.out.println("CTSPropertyPermissionCollection.implies():  permission ! instance of CTSPropertyPermission");
            return false;
        }
        String permName = that.getName();
        int desiredMask = that.getMask();
        int actualMask = 0;
        CTSPropertyPermission tempPerm = (CTSPropertyPermission)this.perms.get(permName);
        return tempPerm != null && ((actualMask |= tempPerm.getMask()) & desiredMask) == desiredMask;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms.values());
    }
}

