/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.DirContext;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ServerInfo;

public class ApplicationContext
implements ServletContext {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private HashMap<String, String> readOnlyAttributes = new HashMap();
    private Object attributesLock = new Object();
    private StandardContext context = null;
    private static final List<String> emptyString = Collections.emptyList();
    private static final List<Servlet> emptyServlet = Collections.emptyList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private ConcurrentMap<String, String> parameters = new ConcurrentHashMap<String, String>();
    private boolean isRestricted;

    public ApplicationContext(StandardContext context) {
        this.context = context;
        this.setAttribute("com.sun.faces.useMyFaces", context.isUseMyFaces());
    }

    public StandardContext getStandardContext() {
        return this.context;
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    public String getContextPath() {
        return this.context.getPath();
    }

    public ServletContext getContext(String uri) {
        return this.context.getContext(uri);
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new Enumerator<String>(this.parameters.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.parameters.putIfAbsent(name, value) == null;
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getEffectiveMinorVersion();
    }

    public String getMimeType(String file) {
        return this.context.getMimeType(file);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return this.context.getNamedDispatcher(name);
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.context.getRequestDispatcher(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.context.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.context.getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.context.getResourcePaths(path);
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration<String> getServletNames() {
        return new Enumerator<String>(emptyString);
    }

    public Enumeration<Servlet> getServlets() {
        return new Enumerator<Servlet>(emptyServlet);
    }

    public void log(String message) {
        this.context.log(message);
    }

    public void log(Exception exception, String message) {
        this.context.log(exception, message);
    }

    public void log(String message, Throwable throwable) {
        this.context.log(message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            value = this.attributes.remove(name);
            if (value == null) {
                return;
            }
        }
        List<EventListener> listeners = this.context.getApplicationEventListeners();
        if (listeners.isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                log.log(Level.WARNING, "AS-WEB-CORE-00084", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        List<EventListener> listeners;
        if (name == null) {
            throw new NullPointerException(rb.getString("AS-WEB-CORE-00085"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        if (name.equals("org.apache.catalina.jsp_classpath") || name.equals("com.sun.jsp.tldUriToLocationMap")) {
            this.setAttributeReadOnly(name);
        }
        if ((listeners = this.context.getApplicationEventListeners()).isEmpty()) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (EventListener eventListener : listeners) {
            if (!(eventListener instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)eventListener;
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                log.log(Level.WARNING, "AS-WEB-CORE-00084", t);
            }
        }
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addServlet(servletName, servletClass);
    }

    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addJspFile(servletName, jspFile);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getVirtualServerName();
    }

    public int getSessionTimeout() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int sessionTimeout) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setSessionTimeout(sessionTimeout);
    }

    public String getRequestCharacterEncoding() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String encoding) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setRequestCharacterEncoding(encoding);
    }

    public String getResponseCharacterEncoding() {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String encoding) {
        if (this.isRestricted) {
            throw new UnsupportedOperationException(rb.getString("AS-WEB-CORE-00083"));
        }
        this.context.setResponseCharacterEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAttributes() {
        ArrayList<String> list = new ArrayList<String>();
        Object object = this.attributesLock;
        synchronized (object) {
            Iterator<String> iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        for (String key : list) {
            this.removeAttribute(key);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttributeReadOnly(String name) {
        Object object = this.attributesLock;
        synchronized (object) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    void setRestricted(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }
}

