/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.monitor;

import com.sun.enterprise.connectors.ConnectionPoolMonitoringExtension;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolProbeProvider;
import com.sun.enterprise.resource.pool.monitor.ConnectionPoolStatsProviderBootstrap;
import com.sun.enterprise.resource.pool.monitor.ConnectorConnPoolProbeProvider;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectionPoolProbeProviderUtil {
    private ConnectionPoolProbeProvider jcaProbeProvider = null;
    private ConnectionPoolProbeProvider jdbcProbeProvider = null;
    @Inject
    private Provider<ConnectionPoolStatsProviderBootstrap> connectionPoolStatsProviderBootstrapProvider;
    @Inject
    private ServiceLocator habitat;

    public void registerProbeProvider() {
        if (ConnectorRuntime.getRuntime().isServer()) {
            this.getConnPoolBootstrap().registerProvider();
        }
    }

    public void createJcaProbeProvider() {
        this.jcaProbeProvider = new ConnectorConnPoolProbeProvider();
    }

    public void createJdbcProbeProvider() {
        List extensions = this.habitat.getAllServices(ConnectionPoolMonitoringExtension.class, new Annotation[0]);
        for (ConnectionPoolMonitoringExtension extension : extensions) {
            this.jdbcProbeProvider = extension.createProbeProvider();
        }
    }

    public ConnectionPoolStatsProviderBootstrap getConnPoolBootstrap() {
        return (ConnectionPoolStatsProviderBootstrap)this.connectionPoolStatsProviderBootstrapProvider.get();
    }

    public ConnectionPoolProbeProvider getJcaProbeProvider() {
        return this.jcaProbeProvider;
    }

    public ConnectionPoolProbeProvider getJdbcProbeProvider() {
        return this.jdbcProbeProvider;
    }
}

