/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ArraySerializerHelper;
import com.sun.xml.rpc.encoding.soap.SOAP12Constants;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterUtil;
import javax.xml.namespace.QName;

class SOAP12ArraySerializerHelper
implements ArraySerializerHelper {
    SOAP12ArraySerializerHelper() {
    }

    @Override
    public void serializeArray(QName elemType, String encodedDims, XMLWriter writer) {
        String attrVal = XMLWriterUtil.encodeQName(writer, elemType);
        writer.writeAttributeUnquoted(SOAP12Constants.QNAME_ENCODING_ITEMTYPE, attrVal);
        writer.writeAttributeUnquoted(SOAP12Constants.QNAME_ENCODING_ARRAYSIZE, encodedDims);
    }

    @Override
    public String encodeArrayDimensions(int[] dims) {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < dims.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(dims[i]);
        }
        return buf.toString();
    }

    @Override
    public String getArrayType(Attributes attrs) {
        return attrs.getValue("http://www.w3.org/2002/06/soap-encoding", "itemType");
    }

    @Override
    public String getElemTypeStr(String arrayType) {
        return arrayType;
    }

    @Override
    public QName getArrayQnameEncoding() {
        return SOAP12Constants.QNAME_ENCODING_ARRAY;
    }

    @Override
    public void whatAmI() {
        System.out.println("I am SOAP1 2");
    }
}

