/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.upgrade;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.LogFacade;
import org.jvnet.hk2.annotations.Service;

@Service(name="webConfigurationUpgrade")
public class WebConfigurationUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    private static final Logger _logger = LogFacade.getLogger();
    @Inject
    private ServerEnvironment serverEnvironment;

    public void postConstruct() {
        WebConfigurationUpgrade.removeSerializedSessions(this.serverEnvironment.getApplicationCompileJspPath());
    }

    private static void removeSerializedSessions(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    WebConfigurationUpgrade.removeSerializedSessions(f);
                    continue;
                }
                if (!f.getName().endsWith("SESSIONS.ser") || FileUtils.deleteFileMaybe((File)f)) continue;
                _logger.log(Level.WARNING, "AS-WEB-GLUE-00160", f.toString());
            }
        }
    }
}

