/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.universal.Duration;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="uptime")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="uptime")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="uptime", description="Uptime", useForAuthorization=true)})
public class UptimeCommand
implements AdminCommand {
    @Inject
    ServerEnvironmentImpl env;
    @Param(name="milliseconds", optional=true, defaultValue="false")
    Boolean milliseconds;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(UptimeCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        long totalTime_ms = this.getUptime();
        String totalTime_mss = "" + totalTime_ms;
        Duration duration = new Duration(totalTime_ms);
        duration.setTerse();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        String message = this.milliseconds != false ? totalTime_mss : localStrings.getLocalString("uptime.output.terse", "Uptime: {0}", new Object[]{duration});
        report.setMessage(message);
        report.getTopMessagePart().addProperty("milliseconds", totalTime_mss);
    }

    private long getUptime() {
        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
        long totalTime_ms = -1L;
        if (mxbean != null) {
            totalTime_ms = mxbean.getUptime();
        }
        if (totalTime_ms <= 0L) {
            long start = this.env.getStartupContext().getCreationTime();
            totalTime_ms = System.currentTimeMillis() - start;
        }
        return totalTime_ms;
    }
}

