/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.Extension;
import org.apache.catalina.util.ManifestResource;
import org.apache.naming.resources.Resource;

public final class ExtensionValidator {
    private static final Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static volatile HashMap<String, Extension> containerAvailableExtensions = null;
    private static ArrayList<ManifestResource> containerManifestResources = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean validateApplication(DirContext dirContext, StandardContext context) throws IOException {
        ManifestResource mre;
        Binding binding;
        String appName = context.getPath();
        ArrayList<ManifestResource> appManifestResources = new ArrayList<ManifestResource>();
        Object appManifestResource = null;
        if (dirContext == null) {
            return false;
        }
        InputStream inputStream = null;
        try {
            NamingEnumeration<Binding> wne = dirContext.listBindings("/META-INF/");
            binding = (Binding)wne.nextElement();
            if (binding.getName().toUpperCase(Locale.ENGLISH).equals("MANIFEST.MF")) {
                Resource resource = (Resource)dirContext.lookup("/META-INF/" + binding.getName());
                inputStream = resource.streamContent();
                Manifest manifest = new Manifest(inputStream);
                inputStream.close();
                inputStream = null;
                String resourceName = "Web Application Manifest";
                mre = new ManifestResource(resourceName, manifest, 2);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException wne) {
        }
        catch (NoSuchElementException wne) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable wne) {}
            }
        }
        NamingEnumeration<Binding> ne = null;
        try {
            ne = dirContext.listBindings("WEB-INF/lib/");
            while (ne != null && ne.hasMoreElements()) {
                Resource resource;
                Manifest jmanifest;
                Object obj;
                binding = (Binding)ne.nextElement();
                if (!binding.getName().toLowerCase(Locale.ENGLISH).endsWith(".jar") || !((obj = dirContext.lookup("/WEB-INF/lib/" + binding.getName())) instanceof Resource) || (jmanifest = ExtensionValidator.getManifest((resource = (Resource)obj).streamContent())) == null) continue;
                mre = new ManifestResource(binding.getName(), jmanifest, 3);
                appManifestResources.add(mre);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return ExtensionValidator.validateManifestResources(appName, appManifestResources);
    }

    private static boolean validateManifestResources(String appName, ArrayList<ManifestResource> resources) {
        boolean passes = true;
        int failureCount = 0;
        HashMap<String, Extension> availableExtensions = null;
        for (ManifestResource mre : resources) {
            ArrayList<Extension> requiredList = mre.getRequiredExtensions();
            if (requiredList == null) continue;
            if (availableExtensions == null) {
                availableExtensions = ExtensionValidator.buildAvailableExtensionsMap(resources);
            }
            if (containerAvailableExtensions == null) {
                containerAvailableExtensions = ExtensionValidator.buildAvailableExtensionsMap(containerManifestResources);
            }
            for (Extension requiredExt : requiredList) {
                Extension targetExt;
                String extId = requiredExt.getUniqueId();
                if (availableExtensions != null && availableExtensions.containsKey(extId)) {
                    targetExt = availableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                if (containerAvailableExtensions != null && containerAvailableExtensions.containsKey(extId)) {
                    targetExt = containerAvailableExtensions.get(extId);
                    if (!targetExt.isCompatibleWith(requiredExt)) continue;
                    requiredExt.setFulfilled(true);
                    continue;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "AS-WEB-CORE-00485", new Object[]{appName, mre.getResourceName(), requiredExt.getExtensionName()});
                }
                passes = false;
                ++failureCount;
            }
        }
        if (!passes && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00486", new Object[]{appName, failureCount});
        }
        return passes;
    }

    private static HashMap<String, Extension> buildAvailableExtensionsMap(ArrayList<ManifestResource> resources) {
        HashMap<String, Extension> availableMap = null;
        for (ManifestResource mre : resources) {
            HashMap<String, Extension> map = mre.getAvailableExtensions();
            if (map == null) continue;
            for (Extension ext : map.values()) {
                if (availableMap == null) {
                    availableMap = new HashMap<String, Extension>();
                    availableMap.put(ext.getUniqueId(), ext);
                    continue;
                }
                if (availableMap.containsKey(ext.getUniqueId())) continue;
                availableMap.put(ext.getUniqueId(), ext);
            }
        }
        return availableMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(InputStream inStream) throws IOException {
        Manifest manifest = null;
        JarInputStream jin = null;
        try {
            jin = new JarInputStream(inStream);
            manifest = jin.getManifest();
            jin.close();
            jin = null;
        }
        finally {
            if (jin != null) {
                try {
                    jin.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return manifest;
    }

    private static void addSystemResource(File jarFile) throws IOException {
        try (FileInputStream fio = new FileInputStream(jarFile);){
            Manifest manifest = ExtensionValidator.getManifest(fio);
            if (manifest != null) {
                ManifestResource mre = new ManifestResource(jarFile.getAbsolutePath(), manifest, 1);
                containerManifestResources.add(mre);
            }
        }
    }

    static {
        String systemClasspath = System.getProperty("java.class.path");
        StringTokenizer strTok = new StringTokenizer(systemClasspath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            File item;
            String classpathItem = strTok.nextToken();
            if (!classpathItem.toLowerCase(Locale.ENGLISH).endsWith(".jar") || !(item = new File(classpathItem)).exists()) continue;
            try {
                ExtensionValidator.addSystemResource(item);
            }
            catch (IOException e) {
                String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00484"), item);
                log.log(Level.SEVERE, msg, e);
            }
        }
    }
}

