/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.util;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.util.Strings;

public class SSHUtil {
    public static final List<String> SSH_KEY_FILE_NAMES = List.of("id_rsa", "id_dsa", "id_ecdsa", "identity");

    public static File getExistingKeyFile() {
        Path h = FileUtils.USER_HOME.toPath();
        for (String keyName : SSH_KEY_FILE_NAMES) {
            File f = h.resolve(Path.of(".ssh", keyName)).toFile();
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    public static File getDefaultKeyFile() {
        return FileUtils.USER_HOME.toPath().resolve(Path.of(".ssh", "id_rsa")).toFile();
    }

    public static boolean isEncryptedKey(File keyFile) throws CommandException {
        try {
            String f = FileUtils.readSmallFile((File)keyFile, (Charset)StandardCharsets.ISO_8859_1).trim();
            return f.startsWith("-----BEGIN ") && f.contains("ENCRYPTED") && f.endsWith(" PRIVATE KEY-----");
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("error.parsing.key", keyFile, ioe.getMessage()), (Throwable)ioe);
        }
    }

    public static void validateKeyFile(File file) throws CommandException {
        if (!file.exists()) {
            throw new CommandException(Strings.get("key.does.not.exist", file));
        }
        if (!file.getName().endsWith(".pub")) {
            String key;
            try {
                key = FileUtils.readSmallFile((File)file, (Charset)StandardCharsets.ISO_8859_1).trim();
            }
            catch (IOException ioe) {
                throw new CommandException(Strings.get("unable.to.read.key", file, ioe.getMessage()));
            }
            if (!key.startsWith("-----BEGIN ") && !key.endsWith(" PRIVATE KEY-----")) {
                throw new CommandException(Strings.get("invalid.key.file", file));
            }
        }
    }
}

