/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;

public class StructMetadata
extends ORMetadata {
    private String name;
    private List<String> fields = new ArrayList<String>();

    public StructMetadata() {
        super("<struct>");
    }

    public StructMetadata(MetadataAnnotation struct, MetadataAccessor accessor) {
        super(struct, accessor);
        this.name = struct.getAttributeString("name");
        for (Object field : struct.getAttributeArray("fields")) {
            this.fields.add((String)field);
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StructMetadata) {
            StructMetadata struct = (StructMetadata)objectToCompare;
            if (!this.valuesMatch(this.fields, struct.getFields())) {
                return false;
            }
            return this.valuesMatch(this.name, ((StructMetadata)objectToCompare).getName());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        return result;
    }

    public void process(MetadataDescriptor descriptor) {
        ClassDescriptor oldDesriptor = descriptor.getClassDescriptor();
        ObjectRelationalDataTypeDescriptor newDescriptor = new ObjectRelationalDataTypeDescriptor();
        newDescriptor.setJavaClassName(oldDesriptor.getJavaClassName());
        newDescriptor.setStructureName(this.getName());
        for (String field : this.fields) {
            newDescriptor.addFieldOrdering(field);
        }
        newDescriptor.setAlias("");
        newDescriptor.getQueryManager().checkDatabaseForDoesExist();
        if (oldDesriptor.isAggregateDescriptor()) {
            newDescriptor.descriptorIsAggregate();
        }
        descriptor.setDescriptor((ClassDescriptor)newDescriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().remove(oldDesriptor);
        descriptor.getProject().getProject().getOrderedDescriptors().add(newDescriptor);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public String getName() {
        return this.name;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public void setName(String name) {
        this.name = name;
    }
}

