/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor.stats;

import com.sun.enterprise.v3.services.impl.monitor.stats.ThreadPoolStatsProvider;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="thread-pool-mon", group="monitoring")
@ManagedObject
@Description(value="Thread Pool Statistics")
public class ThreadPoolStatsProviderGlobal
extends ThreadPoolStatsProvider {
    public ThreadPoolStatsProviderGlobal(String name) {
        super(name);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setMaxThreadsEvent")
    public void setMaxThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="maxNumberOfThreads") int maxNumberOfThreads) {
        this.maxThreadsCount.setCount((long)maxNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setCoreThreadsEvent")
    public void setCoreThreadsEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="coreNumberOfThreads") int coreNumberOfThreads) {
        this.coreThreadsCount.setCount((long)coreNumberOfThreads);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadAllocatedEvent")
    public void threadAllocatedEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId) {
        this.currentThreadCount.increment();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadReleasedEvent")
    public void threadReleasedEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId) {
        this.currentThreadCount.decrement();
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadDispatchedFromPoolEvent")
    public void threadDispatchedFromPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId, @ProbeParam(value="busyThreadCount") long busyThreadCount) {
        this.currentThreadsBusy.setCount(busyThreadCount);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:threadReturnedToPoolEvent")
    public void threadReturnedToPoolEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="threadId") long threadId, @ProbeParam(value="busyThreadCount") long busyThreadCount) {
        this.totalExecutedTasksCount.increment();
        this.currentThreadsBusy.setCount(busyThreadCount);
    }

    @Override
    @ProbeListener(value="glassfish:kernel:thread-pool:setCurrentThreadCountEvent")
    public void setCurrentThreadCountEvent(@ProbeParam(value="monitoringId") String monitoringId, @ProbeParam(value="threadPoolName") String threadPoolName, @ProbeParam(value="currentThreadCount") int currentThreadCount) {
        this.currentThreadCount.setCount((long)currentThreadCount);
    }
}

