/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.FrameworkHelper;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredProcedureGenerator {
    public SchemaManager schemaManager;
    private Map<ClassDescriptor, List<StoredProcedureDefinition>> storedProcedures;
    private Map<ClassDescriptor, Map<String, Map<String, StoredProcedureDefinition>>> mappingStoredProcedures;
    private Map<Integer, Class<?>> intToTypeConverterHash;
    private Writer writer;
    private String prefix;
    private static final String DEFAULT_PREFIX = "";
    private Map<String, StoredProcedureDefinition> sequenceProcedures;
    private static final int MAX_NAME_SIZE = 30;

    public StoredProcedureGenerator(SchemaManager schemaMngr) {
        this.schemaManager = schemaMngr;
        this.sequenceProcedures = new Hashtable<String, StoredProcedureDefinition>();
        this.storedProcedures = new Hashtable<ClassDescriptor, List<StoredProcedureDefinition>>();
        this.mappingStoredProcedures = new Hashtable<ClassDescriptor, Map<String, Map<String, StoredProcedureDefinition>>>();
        this.buildIntToTypeConverterHash();
        this.prefix = DEFAULT_PREFIX;
        this.verify();
    }

    protected void buildIntToTypeConverterHash() {
        this.intToTypeConverterHash = new HashMap();
        this.intToTypeConverterHash.put(8, Double.class);
        this.intToTypeConverterHash.put(-7, Boolean.class);
        this.intToTypeConverterHash.put(-3, Byte[].class);
        this.intToTypeConverterHash.put(-6, Short.class);
        this.intToTypeConverterHash.put(5, Short.class);
        this.intToTypeConverterHash.put(4, Integer.class);
        this.intToTypeConverterHash.put(2, BigDecimal.class);
        this.intToTypeConverterHash.put(6, Float.class);
        this.intToTypeConverterHash.put(1, Character.class);
        this.intToTypeConverterHash.put(12, String.class);
        this.intToTypeConverterHash.put(91, Date.class);
        this.intToTypeConverterHash.put(93, Timestamp.class);
        this.intToTypeConverterHash.put(3, BigDecimal.class);
        this.intToTypeConverterHash.put(-5, BigDecimal.class);
        this.intToTypeConverterHash.put(7, Float.class);
        this.intToTypeConverterHash.put(-1, String.class);
        this.intToTypeConverterHash.put(92, Time.class);
        this.intToTypeConverterHash.put(-2, Byte[].class);
        this.intToTypeConverterHash.put(-4, Byte[].class);
    }

    protected String buildProcedureString(SQLCall call) {
        String stringToModify = call.getSQLString();
        String replacementToken = this.getSession().getPlatform().getStoredProcedureParameterPrefix();
        StringWriter stringWriter = new StringWriter();
        int startIndex = 0;
        int nextParamIndex = 0;
        int tokenIndex = stringToModify.indexOf(63);
        while (tokenIndex != -1) {
            stringWriter.write(stringToModify.substring(startIndex, tokenIndex));
            startIndex = tokenIndex + 1;
            Object parameter = call.getParameters().get(nextParamIndex);
            if (parameter instanceof DatabaseField) {
                DatabaseField field = (DatabaseField)parameter;
                stringWriter.write(replacementToken);
                stringWriter.write(field.getName());
            } else if (parameter instanceof ParameterExpression) {
                ParameterExpression expression = (ParameterExpression)parameter;
                stringWriter.write(replacementToken);
                stringWriter.write(expression.getField().getName());
            } else {
                this.getSession().getPlatform().appendParameter(call, stringWriter, parameter);
            }
            tokenIndex = stringToModify.indexOf(63, startIndex);
            ++nextParamIndex;
        }
        stringWriter.write(stringToModify.substring(startIndex));
        return stringWriter.toString();
    }

    public void generateAmendmentClass(Writer outputWriter, String packageName, String className) throws ValidationException {
        String methodComment = "/**\n * EclipseLink generated method. \n * <b>WARNING</b>: This code was generated by an automated tool.\n * Any changes will be lost when the code is re-generated\n */";
        try {
            List<FieldDefinition> storedProcedureDefinitionArguments;
            StoredProcedureDefinition definition;
            outputWriter.write("package ");
            outputWriter.write(packageName);
            outputWriter.write(";\n\nimport java.util.*;\nimport java.lang.reflect.*;");
            outputWriter.write("\nimport org.eclipse.persistence.queries.*;\nimport org.eclipse.persistence.sessions.*;\nimport org.eclipse.persistence.mappings.*;\n\n/**\n * ");
            outputWriter.write("This is a EclipseLink generated class to add stored procedure amendments to a project.  \n * Any changes to this code will be lost when the class is regenerated \n */\npublic class ");
            outputWriter.write(className);
            outputWriter.write("{\n");
            for (ClassDescriptor descriptor : this.storedProcedures.keySet()) {
                if (descriptor.isDescriptorForInterface() || descriptor.isAggregateDescriptor()) continue;
                outputWriter.write(methodComment);
                outputWriter.write("\npublic static void amend");
                outputWriter.write(descriptor.getJavaClass().getSimpleName());
                outputWriter.write("ClassDescriptor(ClassDescriptor descriptor){\n\t");
                List<StoredProcedureDefinition> storedProcedureVector = this.storedProcedures.get(descriptor);
                Map<String, Map<String, StoredProcedureDefinition>> mappingHashtable = this.mappingStoredProcedures.get(descriptor);
                definition = storedProcedureVector.get(0);
                outputWriter.write("\n\t//INSERT QUERY\n");
                outputWriter.write("\tInsertObjectQuery insertQuery = new InsertObjectQuery();\n\tStoredProcedureCall call = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("insertQuery.setCall(call);\n\tdescriptor.getQueryManager().setInsertQuery(insertQuery);\n\t");
                definition = storedProcedureVector.get(1);
                if (definition != null) {
                    outputWriter.write("\n\t//UPDATE QUERY\n");
                    outputWriter.write("\tUpdateObjectQuery updateQuery = new UpdateObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("updateQuery.setCall(call);\n\tdescriptor.getQueryManager().setUpdateQuery(updateQuery);\n");
                }
                definition = storedProcedureVector.get(2);
                outputWriter.write("\n\t//DELETE QUERY\n");
                outputWriter.write("\tDeleteObjectQuery deleteQuery = new DeleteObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("deleteQuery.setCall(call);\n\tdescriptor.getQueryManager().setDeleteQuery(deleteQuery);\n");
                if (storedProcedureVector.size() > 3) {
                    definition = storedProcedureVector.get(3);
                    outputWriter.write("\n\t//READ OBJECT QUERY\n");
                    outputWriter.write("\tReadObjectQuery readQuery = new ReadObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("readQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadObjectQuery(readQuery);\n");
                }
                if (storedProcedureVector.size() > 4) {
                    definition = storedProcedureVector.get(4);
                    outputWriter.write("\n\t//READ ALL QUERY\n");
                    outputWriter.write("\tReadAllQuery readAllQuery = new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                    outputWriter.write("\tcall.setProcedureName(\"");
                    outputWriter.write(definition.getName());
                    outputWriter.write("\");\n\t");
                    storedProcedureDefinitionArguments = definition.getArguments();
                    for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                        outputWriter.write("call.addNamedArgument(\"");
                        outputWriter.write(fieldDefinition.getName());
                        outputWriter.write("\", \"");
                        outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                        outputWriter.write("\");\n\t");
                    }
                    outputWriter.write("readAllQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadAllQuery(readAllQuery);\n");
                }
                if (mappingHashtable != null) {
                    outputWriter.write("\n\t//MAPPING QUERIES\n");
                    outputWriter.write("\tReadAllQuery mappingQuery; \n");
                    outputWriter.write("\tDeleteAllQuery deleteMappingQuery; \n");
                    for (String mappingName : mappingHashtable.keySet()) {
                        definition = mappingHashtable.get(mappingName).get("1MREAD");
                        if (definition != null) {
                            outputWriter.write("\n\t//MAPPING READALL QUERY FOR " + mappingName + "\n");
                            outputWriter.write("\tmappingQuery= new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                            outputWriter.write("\tcall.setProcedureName(\"");
                            outputWriter.write(definition.getName());
                            outputWriter.write("\");\n\t");
                            storedProcedureDefinitionArguments = definition.getArguments();
                            for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                                outputWriter.write("call.addNamedArgument(\"");
                                outputWriter.write(fieldDefinition.getName());
                                outputWriter.write("\", \"");
                                outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                                outputWriter.write("\");\n\t");
                            }
                            outputWriter.write("mappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + mappingName + "\")).setCustomSelectionQuery(mappingQuery);\n");
                        }
                        if ((definition = mappingHashtable.get(mappingName).get("1MDALL")) == null) continue;
                        outputWriter.write("\n\t//MAPPING DELETEALL QUERY FOR " + mappingName + "\n");
                        outputWriter.write("\tdeleteMappingQuery= new DeleteAllQuery();\n\tcall = new StoredProcedureCall();\n");
                        outputWriter.write("\tcall.setProcedureName(\"");
                        outputWriter.write(definition.getName());
                        outputWriter.write("\");\n\t");
                        storedProcedureDefinitionArguments = definition.getArguments();
                        for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                            outputWriter.write("call.addNamedArgument(\"");
                            outputWriter.write(fieldDefinition.getName());
                            outputWriter.write("\", \"");
                            outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                            outputWriter.write("\");\n\t");
                        }
                        outputWriter.write("deleteMappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + mappingName + "\")).setCustomDeleteAllQuery(deleteMappingQuery);\n");
                    }
                }
                outputWriter.write("}\n");
            }
            definition = this.sequenceProcedures.get("SELECT");
            if (definition != null) {
                outputWriter.write("\n\tValueReadQuery seqSelectQuery = new ValueReadQuery();\n\tcall = new StoredProcedureCall();\n");
                outputWriter.write("\tcall.setProcedureName(\"");
                outputWriter.write(definition.getName());
                outputWriter.write("\");\n\t");
                storedProcedureDefinitionArguments = definition.getArguments();
                for (FieldDefinition fieldDefinition : storedProcedureDefinitionArguments) {
                    outputWriter.write("call.addNamedArgument(\"");
                    outputWriter.write(fieldDefinition.getName());
                    outputWriter.write("\", \"");
                    outputWriter.write(this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                    outputWriter.write("seqSelectQuery.addArgument(\"" + this.getFieldName(fieldDefinition.getName()));
                    outputWriter.write("\");\n\t");
                }
                outputWriter.write("seqSelectQuery.setCall(call);\n\tproject.getLogin().setSelectSequenceNumberQuery(seqSelectQuery);\n");
            }
            outputWriter.write("}\n");
            outputWriter.write(methodComment);
            outputWriter.write("\npublic static void amendDescriptors(org.eclipse.persistence.sessions.Project project) throws Exception{");
            outputWriter.write("\n\tamendSequences(project);");
            outputWriter.write("\n\tfor(Iterator enumtr = project.getDescriptors().values().iterator(); enumtr.hasNext();) {");
            outputWriter.write("\n\t\tDescriptor descriptor = (ClassDescriptor)enumtr.next();");
            outputWriter.write("\n\t\tif(!(descriptor.isAggregateDescriptor() || descriptor.isDescriptorForInterface())) {");
            outputWriter.write("\n\t\t\tMethod method = " + className + ".class.getMethod(\"amend\"+descriptor.getJavaClass().getSimpleName()+\"ClassDescriptor\", new Class[] {ClassDescriptor.class});");
            outputWriter.write("\n\t\t\tmethod.invoke(null, new Object[] {descriptor});");
            outputWriter.write("\n\t\t}");
            outputWriter.write("\n\t}");
            outputWriter.write("\n}");
            outputWriter.write("\n}\n");
            outputWriter.flush();
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected StoredProcedureDefinition generateDeleteStoredProcedure(ClassDescriptor descriptor) {
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.setDescriptor(descriptor);
        deleteQuery.setModifyRow(new DatabaseRecord());
        return this.generateObjectStoredProcedure(deleteQuery, descriptor.getPrimaryKeyFields(), "DEL_");
    }

    protected StoredProcedureDefinition generateInsertStoredProcedure(ClassDescriptor descriptor) {
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        insertQuery.setDescriptor(descriptor);
        insertQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateInsertRow(this.getSession()));
        return this.generateObjectStoredProcedure(insertQuery, descriptor.getFields(), "INS_");
    }

    protected Map<String, Map<String, StoredProcedureDefinition>> generateMappingStoredProcedures(ClassDescriptor descriptor) {
        List<DatabaseMapping> mappings = descriptor.getMappings();
        Hashtable<String, Map<String, StoredProcedureDefinition>> mappingSP = new Hashtable<String, Map<String, StoredProcedureDefinition>>();
        for (DatabaseMapping mapping : mappings) {
            Hashtable<String, StoredProcedureDefinition> mappingTable = new Hashtable<String, StoredProcedureDefinition>();
            if (!mapping.isOneToManyMapping()) continue;
            if (!this.getSession().getPlatform().isOracle()) {
                mappingTable.put("1MREAD", this.generateOneToManyMappingReadProcedure((OneToManyMapping)mapping));
            }
            if (mapping.isPrivateOwned()) {
                mappingTable.put("1MDALL", this.generateOneToManyMappingDeleteAllProcedure((OneToManyMapping)mapping));
            }
            mappingSP.put(mapping.getAttributeName(), mappingTable);
        }
        return mappingSP;
    }

    protected StoredProcedureDefinition generateObjectStoredProcedure(DatabaseQuery query, List<DatabaseField> fields, String namePrefix) {
        String className = query.getDescriptor().getJavaClass().getSimpleName();
        return this.generateStoredProcedure(query, fields, this.getPrefix() + namePrefix + className);
    }

    protected StoredProcedureDefinition generateOneToManyMappingDeleteAllProcedure(OneToManyMapping mapping) {
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setDescriptor(targetDescriptor);
        deleteAllQuery.setReferenceClass(targetDescriptor.getJavaClass());
        deleteAllQuery.setSelectionCriteria(mapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(mapping, deleteAllQuery, mapping.getTargetForeignKeysToSourceKeys(), "D_1M_");
    }

    protected StoredProcedureDefinition generateOneToManyMappingProcedures(OneToManyMapping mapping, DatabaseQuery query, Map<DatabaseField, DatabaseField> fields, String namePrefix) {
        String sourceClassName = mapping.getDescriptor().getJavaClass().getSimpleName();
        return this.generateStoredProcedure(query, new ArrayList<DatabaseField>(fields.values()), this.getPrefix() + namePrefix + sourceClassName + "_" + mapping.getAttributeName());
    }

    protected StoredProcedureDefinition generateOneToManyMappingReadProcedure(OneToManyMapping mapping) {
        ClassDescriptor targetDescriptor = mapping.getReferenceDescriptor();
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(targetDescriptor);
        readAllQuery.setReferenceClass(targetDescriptor.getJavaClass());
        readAllQuery.setSelectionCriteria(mapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(mapping, readAllQuery, mapping.getTargetForeignKeysToSourceKeys(), "R_1M_");
    }

    protected StoredProcedureDefinition generateReadAllStoredProcedure(ClassDescriptor descriptor) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(descriptor);
        readAllQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readAllQuery, descriptor.getPrimaryKeyFields(), "RALL_");
    }

    protected StoredProcedureDefinition generateReadStoredProcedure(ClassDescriptor descriptor) {
        ReadObjectQuery readQuery = new ReadObjectQuery();
        readQuery.setDescriptor(descriptor);
        readQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readQuery, descriptor.getPrimaryKeyFields(), "READ_");
    }

    protected void generateSequenceStoredProcedures(Project project) {
        DatabaseLogin login = (DatabaseLogin)project.getDatasourceLogin();
        if (login.shouldUseNativeSequencing()) {
            return;
        }
        if (project.usesSequencing() && !this.getSession().getPlatform().isOracle()) {
            StoredProcedureDefinition definition = new StoredProcedureDefinition();
            definition.setName(FrameworkHelper.truncate(project.getName() + "SEQ_SEL", 30));
            definition.addArgument("SEQ_NAME", String.class, 100);
            definition.addArgument("PREALLOC_SIZE", BigDecimal.class, 10);
            definition.addStatement("UPDATE " + ((TableSequence)login.getDefaultSequence()).getTableName() + " SET " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " = " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " + " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "PREALLOC_SIZE WHERE " + ((TableSequence)login.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            definition.addStatement("SELECT " + ((TableSequence)login.getDefaultSequence()).getCounterFieldName() + " FROM " + ((TableSequence)login.getDefaultSequence()).getTableName() + " WHERE " + ((TableSequence)login.getDefaultSequence()).getNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            this.sequenceProcedures.put("SELECT", definition);
            this.writeDefinition(definition);
        }
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery query, List<DatabaseField> fields, String name) {
        return this.generateStoredProcedure(query, fields, new DatabaseRecord(), name);
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery query, List<DatabaseField> fields, AbstractRecord rowForPrepare, String name) {
        StoredProcedureDefinition definition = new StoredProcedureDefinition();
        ArrayList<String> statementVector = new ArrayList<String>();
        query.checkPrepare(this.getSession(), rowForPrepare, true);
        List<DatasourceCall> callVector = ((CallQueryMechanism)query.getQueryMechanism()).getCalls();
        if (callVector.isEmpty() && ((CallQueryMechanism)query.getQueryMechanism()).getCall() != null) {
            callVector.add(((CallQueryMechanism)query.getQueryMechanism()).getCall());
        }
        for (SQLCall sQLCall : callVector) {
            statementVector.add(this.buildProcedureString(sQLCall));
        }
        definition.setStatements(statementVector);
        Hashtable<String, AbstractRecord> fieldNames = new Hashtable<String, AbstractRecord>();
        List<DatabaseField> primaryKeyFields = fields;
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            DatabaseField databaseField = primaryKeyFields.get(index);
            fieldNames.put(databaseField.getName(), this.schemaManager.getColumnInfo(databaseField.getTableName(), databaseField.getName()).get(0));
        }
        definition.setName(FrameworkHelper.truncate(name, 30));
        Iterator iterator = fieldNames.keySet().iterator();
        String prefixArgToken = this.getSession().getPlatform().isOracle() ? this.getSession().getPlatform().getStoredProcedureParameterPrefix() : DEFAULT_PREFIX;
        while (iterator.hasNext()) {
            AbstractRecord dataRow = (AbstractRecord)fieldNames.get(iterator.next());
            Number dataType = (Number)dataRow.get("DATA_TYPE");
            Class<?> type = this.getFieldType(dataType);
            String typeName = (String)dataRow.get("TYPE_NAME");
            if (type != null || typeName == null || typeName.isEmpty()) {
                definition.addArgument(prefixArgToken + String.valueOf(dataRow.get("COLUMN_NAME")), type, ((Number)dataRow.get("COLUMN_SIZE")).intValue());
                continue;
            }
            definition.addArgument(prefixArgToken + String.valueOf(dataRow.get("COLUMN_NAME")), typeName);
        }
        return definition;
    }

    public void generateStoredProcedures() {
        boolean wasBinding = this.getSession().getLogin().shouldBindAllParameters();
        this.getSession().getLogin().setShouldBindAllParameters(false);
        Map<Class<?>, ClassDescriptor> descriptors = this.getSession().getProject().getDescriptors();
        Iterator<Class<?>> iterator = descriptors.keySet().iterator();
        this.generateSequenceStoredProcedures(this.getSession().getProject());
        while (iterator.hasNext()) {
            ClassDescriptor desc = descriptors.get(iterator.next());
            if (desc.isDescriptorForInterface() || desc.isDescriptorTypeAggregate()) continue;
            StoredProcedureDefinition definition = this.generateInsertStoredProcedure(desc);
            ArrayList<StoredProcedureDefinition> definitionVector = new ArrayList<StoredProcedureDefinition>();
            definitionVector.add(definition);
            this.writeDefinition(definition);
            definition = this.generateUpdateStoredProcedure(desc);
            definitionVector.add(definition);
            this.writeDefinition(definition);
            definition = this.generateDeleteStoredProcedure(desc);
            definitionVector.add(definition);
            this.writeDefinition(definition);
            if (!this.getSession().getPlatform().isOracle()) {
                definition = this.generateReadStoredProcedure(desc);
                definitionVector.add(definition);
                this.writeDefinition(definition);
                definition = this.generateReadAllStoredProcedure(desc);
                definitionVector.add(definition);
                this.writeDefinition(definition);
            }
            Map<String, Map<String, StoredProcedureDefinition>> mappingDefinitions = this.generateMappingStoredProcedures(desc);
            for (Map<String, StoredProcedureDefinition> table : mappingDefinitions.values()) {
                definition = table.get("1MREAD");
                if (definition != null) {
                    this.writeDefinition(definition);
                }
                if ((definition = table.get("1MDALL")) == null) continue;
                this.writeDefinition(definition);
            }
            this.storedProcedures.put(desc, definitionVector);
            if (mappingDefinitions.isEmpty()) continue;
            this.mappingStoredProcedures.put(desc, mappingDefinitions);
        }
        this.getSession().getLogin().setShouldBindAllParameters(wasBinding);
    }

    public void generateStoredProcedures(Writer writerOrNull) {
        this.writer = writerOrNull;
        this.schemaManager.outputDDLToWriter(this.getWriter());
        this.generateStoredProcedures();
        try {
            this.getWriter().flush();
        }
        catch (IOException exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    protected StoredProcedureDefinition generateUpdateStoredProcedure(ClassDescriptor descriptor) {
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        updateQuery.setDescriptor(descriptor);
        updateQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateUpdateRow(this.getSession()));
        return this.generateObjectStoredProcedure(updateQuery, descriptor.getFields(), "UPD_");
    }

    protected String getFieldName(String argumentName) {
        if (this.getSession().getPlatform().isOracle()) {
            return argumentName.substring(this.getSession().getPlatform().getStoredProcedureParameterPrefix().length());
        }
        return argumentName;
    }

    protected Class<?> getFieldType(Object jdbcDataType) {
        Integer key = ((Number)jdbcDataType).intValue();
        return this.intToTypeConverterHash.get(key);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public AbstractSession getSession() {
        return this.schemaManager.getSession();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    protected void verify() throws ValidationException {
        if (this.getSession().getProject().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingNotSupportedWithStoredProcedureGeneration();
        }
    }

    public void writeDefinition(StoredProcedureDefinition definition) {
        this.schemaManager.replaceObject(definition);
    }
}

