/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.CLIProcessExecutor;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.optional.DatabaseCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.util.HashMap;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-database")
@PerLookup
public final class StopDatabaseCommand
extends DatabaseCommand {
    private static final LocalStringsImpl strings = new LocalStringsImpl(StopDatabaseCommand.class);
    @Param(name="dbuser", optional=true)
    private String dbUser;
    private File dbPasswordFile;
    private String dbPassword;

    public String[] stopDatabaseCmd() throws Exception {
        this.passwords = new HashMap();
        String passwordfile = this.getOption("passwordfile");
        if (passwordfile != null) {
            this.dbPasswordFile = new File(passwordfile);
            this.dbPasswordFile = SmartFile.sanitize((File)this.dbPasswordFile);
        }
        if (this.dbPasswordFile != null) {
            this.passwords = CLIUtil.readPasswordFileOptions(this.dbPasswordFile.getPath(), true);
            this.dbPassword = (String)this.passwords.get(Environment.getPrefix() + "DBPASSWORD");
        }
        if (Utility.isAllNull((Object[])new Object[]{this.dbUser, this.dbPassword})) {
            if (OS.isDarwin()) {
                return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
            }
            return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false"};
        }
        if (OS.isDarwin()) {
            return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false", this.dbUser, this.dbPassword};
        }
        return new String[]{String.valueOf(this.javaHome) + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + String.valueOf(this.installRoot) + File.separator + "lib", "-cp", String.valueOf(this.sClasspath) + File.pathSeparator + String.valueOf(this.sDatabaseClasspath), "com.sun.enterprise.admin.cli.optional.DerbyControl", "shutdown", this.dbHost, this.dbPort, "false", this.dbUser, this.dbPassword};
    }

    @Override
    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            this.prepareProcessExecutor();
            CLIProcessExecutor cliProcessExecutor = new CLIProcessExecutor();
            cliProcessExecutor.execute("pingDatabaseCmd", this.pingDatabaseCmd(false), true);
            if (cliProcessExecutor.exitValue() > 0) {
                throw new CommandException(strings.get("StopDatabaseStatus", new Object[]{this.dbHost, this.dbPort}));
            }
            if (cliProcessExecutor.exitValue() < 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}));
            }
            cliProcessExecutor.execute("stopDatabaseCmd", this.stopDatabaseCmd(), true);
            if (cliProcessExecutor.exitValue() > 0) {
                throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}));
            }
        }
        catch (Exception e) {
            throw new CommandException(strings.get("UnableToStopDatabase", new Object[]{"derby.log"}), (Throwable)e);
        }
        return 0;
    }
}

