/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.java.Constants;

public final class Vset
implements Constants {
    long vset;
    long uset;
    long[] x;
    static final long[] emptyX = new long[0];
    static final long[] fullX = new long[0];
    static final int VBITS = 64;
    static final Vset DEAD_END = new Vset(-1L, -1L, fullX);

    public Vset() {
        this.x = emptyX;
    }

    private Vset(long vset, long uset, long[] x) {
        this.vset = vset;
        this.uset = uset;
        this.x = x;
    }

    public Vset copy() {
        if (this == DEAD_END) {
            return this;
        }
        Vset vs = new Vset(this.vset, this.uset, this.x);
        if (this.x.length > 0) {
            vs.growX(this.x.length);
        }
        return vs;
    }

    private void growX(int length) {
        long[] newX = new long[length];
        long[] oldX = this.x;
        for (int i = 0; i < oldX.length; ++i) {
            newX[i] = oldX[i];
        }
        this.x = newX;
    }

    public boolean isDeadEnd() {
        return this == DEAD_END;
    }

    public boolean isReallyDeadEnd() {
        return this.x == fullX;
    }

    public Vset clearDeadEnd() {
        if (this == DEAD_END) {
            return new Vset(-1L, -1L, fullX);
        }
        return this;
    }

    public boolean testVar(int varNumber) {
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2;
            if (i >= this.x.length) {
                return this.x == fullX;
            }
            return (this.x[i] & bit) != 0L;
        }
        return (this.vset & bit) != 0L;
    }

    public boolean testVarUnassigned(int varNumber) {
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2 + 1;
            if (i >= this.x.length) {
                return this.x == fullX;
            }
            return (this.x[i] & bit) != 0L;
        }
        return (this.uset & bit) != 0L;
    }

    public Vset addVar(int varNumber) {
        if (this.x == fullX) {
            return this;
        }
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2;
            if (i >= this.x.length) {
                this.growX(i + 1);
            }
            int n = i;
            this.x[n] = this.x[n] | bit;
            if (i + 1 < this.x.length) {
                int n2 = i + 1;
                this.x[n2] = this.x[n2] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            this.vset |= bit;
            this.uset &= bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    public Vset addVarUnassigned(int varNumber) {
        if (this.x == fullX) {
            return this;
        }
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2 + 1;
            if (i >= this.x.length) {
                this.growX(i + 1);
            }
            int n = i;
            this.x[n] = this.x[n] | bit;
            int n2 = i - 1;
            this.x[n2] = this.x[n2] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            this.uset |= bit;
            this.vset &= bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    public Vset clearVar(int varNumber) {
        if (this.x == fullX) {
            return this;
        }
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2;
            if (i >= this.x.length) {
                return this;
            }
            int n = i;
            this.x[n] = this.x[n] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
            if (i + 1 < this.x.length) {
                int n2 = i + 1;
                this.x[n2] = this.x[n2] & (bit ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            this.vset &= bit ^ 0xFFFFFFFFFFFFFFFFL;
            this.uset &= bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return this;
    }

    public Vset join(Vset other) {
        if (this == DEAD_END) {
            return other.copy();
        }
        if (other == DEAD_END) {
            return this;
        }
        if (this.x == fullX) {
            return other.copy();
        }
        if (other.x == fullX) {
            return this;
        }
        this.vset &= other.vset;
        this.uset &= other.uset;
        if (other.x == emptyX) {
            this.x = emptyX;
        } else {
            int i;
            long[] otherX = other.x;
            int selfLength = this.x.length;
            int limit = otherX.length < selfLength ? otherX.length : selfLength;
            for (i = 0; i < limit; ++i) {
                int n = i;
                this.x[n] = this.x[n] & otherX[i];
            }
            for (i = limit; i < selfLength; ++i) {
                this.x[i] = 0L;
            }
        }
        return this;
    }

    public Vset addDAandJoinDU(Vset other) {
        int i;
        if (this == DEAD_END) {
            return this;
        }
        if (other == DEAD_END) {
            return other;
        }
        if (this.x == fullX) {
            return this;
        }
        if (other.x == fullX) {
            return other.copy();
        }
        this.vset |= other.vset;
        this.uset = this.uset & other.uset & (other.vset ^ 0xFFFFFFFFFFFFFFFFL);
        int selfLength = this.x.length;
        long[] otherX = other.x;
        int otherLength = otherX.length;
        if (otherX != emptyX) {
            if (otherLength > selfLength) {
                this.growX(otherLength);
            }
            for (i = 0; i < otherLength; ++i) {
                int n = i;
                this.x[n] = this.x[n] | otherX[i];
                if (++i == otherLength) break;
                this.x[i] = this.x[i] & otherX[i] & (otherX[i - 1] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        for (i = otherLength | 1; i < selfLength; i += 2) {
            this.x[i] = 0L;
        }
        return this;
    }

    public static Vset firstDAandSecondDU(Vset sourceDA, Vset sourceDU) {
        if (sourceDA.x == fullX) {
            return sourceDA.copy();
        }
        long[] sourceDAx = sourceDA.x;
        int lenDA = sourceDAx.length;
        long[] sourceDUx = sourceDU.x;
        int lenDU = sourceDUx.length;
        int limit = lenDA > lenDU ? lenDA : lenDU;
        long[] x = emptyX;
        if (limit > 0) {
            int i;
            x = new long[limit];
            for (i = 0; i < lenDA; i += 2) {
                x[i] = sourceDAx[i];
            }
            for (i = 1; i < lenDU; i += 2) {
                x[i] = sourceDUx[i];
            }
        }
        return new Vset(sourceDA.vset, sourceDU.uset, x);
    }

    public Vset removeAdditionalVars(int varNumber) {
        if (this.x == fullX) {
            return this;
        }
        long bit = 1L << varNumber;
        if (varNumber >= 64) {
            int i = (varNumber / 64 - 1) * 2;
            if (i < this.x.length) {
                int n = i++;
                this.x[n] = this.x[n] & bit - 1L;
                if (i < this.x.length) {
                    int n2 = i;
                    this.x[n2] = this.x[n2] & bit - 1L;
                }
                while (++i < this.x.length) {
                    this.x[i] = 0L;
                }
            }
        } else {
            if (this.x.length > 0) {
                this.x = emptyX;
            }
            this.vset &= bit - 1L;
            this.uset &= bit - 1L;
        }
        return this;
    }

    public int varLimit() {
        int result;
        long vset;
        block5: {
            for (int i = this.x.length / 2 * 2; i >= 0; i -= 2) {
                if (i == this.x.length) continue;
                vset = this.x[i];
                if (i + 1 < this.x.length) {
                    vset |= this.x[i + 1];
                }
                if (vset == 0L) continue;
                result = (i / 2 + 1) * 64;
                break block5;
            }
            vset = this.vset;
            if ((vset |= this.uset) != 0L) {
                result = 0;
            } else {
                return 0;
            }
        }
        while (vset != 0L) {
            ++result;
            vset >>>= 1;
        }
        return result;
    }

    public String toString() {
        if (this == DEAD_END) {
            return "{DEAD_END}";
        }
        StringBuilder sb = new StringBuilder("{");
        int maxVar = 64 * (1 + (this.x.length + 1) / 2);
        for (int i = 0; i < maxVar; ++i) {
            if (this.testVarUnassigned(i)) continue;
            if (sb.length() > 1) {
                sb.append(' ');
            }
            sb.append(i);
            if (this.testVar(i)) continue;
            sb.append('?');
        }
        if (this.x == fullX) {
            sb.append("...DEAD_END");
        }
        sb.append('}');
        return sb.toString();
    }
}

