/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class StoredFunctionDefinition
extends StoredProcedureDefinition {
    public StoredFunctionDefinition() {
        this.addOutputArgument(new FieldDefinition());
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(session.getPlatform().getClass().getSimpleName());
        }
        super.buildCreationWriter(session, writer);
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(session.getPlatform().getClass().getSimpleName());
        }
        super.buildDeletionWriter(session, writer);
        return writer;
    }

    @Override
    public String getCreationHeader() {
        return "CREATE FUNCTION ";
    }

    @Override
    public String getDeletionHeader() {
        return "DROP FUNCTION ";
    }

    @Override
    public int getFirstArgumentIndex() {
        return 1;
    }

    public void setReturnType(Class<?> type) {
        FieldDefinition argument = this.getArguments().get(0);
        argument.setType(type);
    }

    @Override
    protected void printReturn(Writer writer, AbstractSession session) throws ValidationException {
        try {
            session.getPlatform().printStoredFunctionReturnKeyWord(writer);
            FieldDefinition argument = this.getArguments().get(0);
            this.printArgument(argument, writer, session);
            writer.write("\n");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }
}

