/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.MethodDefinition;

public class NonreflectiveMethodDefinition
extends MethodDefinition {
    protected List<String> argumentTypeNames = new ArrayList<String>(5);

    public void addArgument(String argumentType, String argumentName) {
        this.getArgumentNames().add(argumentName);
        this.getArgumentTypes().add(argumentType);
    }

    private void adjustArgumentTypeNames(Map<String, Set<String>> typeNameMap) {
        for (String argumentTypeName : new ArrayList<String>(this.getArgumentTypeNames())) {
            String adjustedArgumentTypeName;
            if (argumentTypeName.equals(adjustedArgumentTypeName = NonreflectiveMethodDefinition.adjustTypeName(argumentTypeName, typeNameMap))) continue;
            this.replaceArgumentTypeName(argumentTypeName, adjustedArgumentTypeName);
        }
    }

    @Override
    protected void adjustTypeNames(Map<String, Set<String>> typeNameMap) {
        super.adjustTypeNames(typeNameMap);
        this.adjustArgumentTypeNames(typeNameMap);
    }

    @Override
    protected boolean argumentsEqual(MethodDefinition methodDefinition) {
        Object[] args2;
        Object[] args1 = this.getArgumentTypes().toArray();
        if (args1.length == (args2 = methodDefinition.getArgumentTypes().toArray()).length) {
            for (int i = 0; i < args1.length; ++i) {
                if ((args1[i] != null || args1[i] == args2[i]) && args1[i].equals(args2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected List<String> getArgumentTypeNames() {
        return this.getArgumentTypes();
    }

    @Override
    public List<String> getArgumentTypes() {
        return this.argumentTypeNames;
    }

    protected void replaceArgumentTypeName(String oldArgumentTypeName, String newArgumentTypeName) {
        int index = this.getArgumentTypeNames().indexOf(oldArgumentTypeName);
        this.getArgumentTypeNames().remove(oldArgumentTypeName);
        this.getArgumentTypeNames().add(index, newArgumentTypeName);
    }

    @Override
    protected void writeArguments(CodeGenerator generator) {
        boolean isFirst = true;
        for (int index = 0; index < this.getArgumentTypes().size(); ++index) {
            String argument = this.getArgumentTypes().get(index);
            if (isFirst) {
                isFirst = false;
            } else {
                generator.write(", ");
            }
            generator.write(argument);
            generator.write(" ");
            generator.write(this.getArgumentNames().get(index));
        }
    }
}

