/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.v3.services.impl.ContainerMapper;
import com.sun.enterprise.v3.services.impl.GlassfishErrorPageGenerator;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpAdapter;
import com.sun.enterprise.v3.services.impl.monitor.ConnectionMonitor;
import com.sun.enterprise.v3.services.impl.monitor.FileCacheMonitor;
import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.KeepAliveMonitor;
import com.sun.enterprise.v3.services.impl.monitor.ThreadPoolMonitor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.config.GenericGrizzlyListener;
import org.glassfish.grizzly.config.GrizzlyListener;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpServerFilter;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.KeepAliveProbe;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.ServerFilterConfiguration;
import org.glassfish.grizzly.http.server.filecache.FileCacheProbe;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.internal.grizzly.ContextMapper;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.config.types.Property;

public class GlassfishNetworkListener
extends GenericGrizzlyListener {
    private final GrizzlyService grizzlyService;
    private final NetworkListener networkListener;
    private final Logger logger;
    private volatile HttpAdapter httpAdapter;

    public GlassfishNetworkListener(GrizzlyService grizzlyService, NetworkListener networkListener, Logger logger) {
        this.grizzlyService = grizzlyService;
        this.networkListener = networkListener;
        this.logger = logger;
    }

    public NetworkListener getNetworkListener() {
        return this.networkListener;
    }

    public void stop() throws IOException {
        ServiceLocator locator = this.grizzlyService.getServiceLocator();
        IndexedFilter removeFilter = BuilderHelper.createNameAndContractFilter((String)Mapper.class.getName(), (String)(this.address.toString() + this.port));
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration config = dcs.createDynamicConfiguration();
        config.addUnbindFilter((Filter)removeFilter);
        config.commit();
        this.unregisterMonitoringStatsProviders();
        super.stop();
    }

    public <T> T getAdapter(Class<T> adapterClass) {
        if (HttpAdapter.class.equals(adapterClass)) {
            return (T)this.httpAdapter;
        }
        return (T)super.getAdapter(adapterClass);
    }

    protected void configureTransport(NetworkListener networkListener, Transport transportConfig, FilterChainBuilder filterChainBuilder) {
        super.configureTransport(networkListener, transportConfig, filterChainBuilder);
        this.transport.getConnectionMonitoringConfig().addProbes((Object[])new ConnectionProbe[]{new ConnectionMonitor(this.grizzlyService.getMonitoring(), this.name, (org.glassfish.grizzly.Transport)this.transport)});
    }

    protected void configureHttpProtocol(ServiceLocator habitat, NetworkListener networkListener, Http http, FilterChainBuilder filterChainBuilder, boolean securityEnabled) {
        if (this.httpAdapter != null) {
            super.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder, securityEnabled);
            return;
        }
        this.registerMonitoringStatsProviders();
        V3Mapper mapper = new V3Mapper(this.logger);
        mapper.setPort(this.port);
        mapper.setId(this.name);
        ContainerMapper containerMapper = new ContainerMapper(this.grizzlyService, (GrizzlyListener)this);
        containerMapper.setMapper((ContextMapper)mapper);
        containerMapper.setDefaultHost(http.getDefaultVirtualServer());
        containerMapper.setRequestURIEncoding(http.getUriEncoding());
        containerMapper.configureMapper();
        VirtualServer vs = null;
        String webAppRootPath = null;
        List list = this.grizzlyService.getServiceLocator().getAllServices(VirtualServer.class, new Annotation[0]);
        String vsName = http.getDefaultVirtualServer();
        for (VirtualServer virtualServer : list) {
            if (!virtualServer.getId().equals(vsName)) continue;
            vs = virtualServer;
            webAppRootPath = vs.getDocroot();
            if (this.grizzlyService.hasMapperUpdateListener() || vs.getProperty() == null || vs.getProperty().isEmpty()) break;
            for (Property p : vs.getProperty()) {
                String propertyName = p.getName();
                if (!propertyName.startsWith("alternatedocroot")) continue;
                String value = p.getValue();
                String[] mapping = value.split(" ");
                if (mapping.length != 2) {
                    this.logger.log(Level.WARNING, "Invalid alternate_docroot {0}", value);
                    continue;
                }
                String docBase = mapping[1].substring("dir=".length());
                String urlPattern = mapping[0].substring("from=".length());
                containerMapper.addAlternateDocBase(urlPattern, docBase);
            }
        }
        this.httpAdapter = new HttpAdapterImpl(vs, containerMapper, webAppRootPath);
        containerMapper.addDocRoot(webAppRootPath);
        AbstractActiveDescriptor aad = BuilderHelper.createConstantDescriptor((Object)mapper);
        aad.addContractType(Mapper.class);
        aad.setName(this.address.toString() + this.port);
        ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.grizzlyService.getServiceLocator(), (Descriptor)aad);
        super.configureHttpProtocol(habitat, networkListener, http, filterChainBuilder, securityEnabled);
        Protocol protocol = http.getParent();
        for (NetworkListener listener : protocol.findNetworkListeners()) {
            this.grizzlyService.notifyMapperUpdateListeners(listener, (Mapper)mapper);
        }
    }

    protected ServerFilterConfiguration getHttpServerFilterConfiguration(Http http) {
        ServerFilterConfiguration config = super.getHttpServerFilterConfiguration(http);
        config.setDefaultErrorPageGenerator((ErrorPageGenerator)new GlassfishErrorPageGenerator());
        return config;
    }

    protected HttpHandler getHttpHandler() {
        return this.httpAdapter.getMapper();
    }

    protected KeepAlive configureKeepAlive(Http http) {
        KeepAlive keepAlive = super.configureKeepAlive(http);
        keepAlive.getMonitoringConfig().addProbes((Object[])new KeepAliveProbe[]{new KeepAliveMonitor(this.grizzlyService.getMonitoring(), this.name, keepAlive)});
        return keepAlive;
    }

    protected org.glassfish.grizzly.http.server.filecache.FileCache configureHttpFileCache(FileCache cache) {
        org.glassfish.grizzly.http.server.filecache.FileCache fileCache = super.configureHttpFileCache(cache);
        fileCache.getMonitoringConfig().addProbes((Object[])new FileCacheProbe[]{new FileCacheMonitor(this.grizzlyService.getMonitoring(), this.name, fileCache)});
        return fileCache;
    }

    protected ThreadPoolConfig configureThreadPoolConfig(NetworkListener networkListener, ThreadPool threadPool) {
        ThreadPoolConfig config = super.configureThreadPoolConfig(networkListener, threadPool);
        config.getInitialMonitoringConfig().addProbes((Object[])new ThreadPoolProbe[]{new ThreadPoolMonitor(this.grizzlyService.getMonitoring(), this.name, config)});
        return config;
    }

    protected HttpServerFilter createHttpServerCodecFilter(Http http, boolean isChunkedEnabled, int headerBufferLengthBytes, String defaultResponseType, KeepAlive keepAlive, DelayedExecutor delayedExecutor, int maxRequestHeaders, int maxResponseHeaders) {
        GlassfishHttpCodecFilter httpCodecFilter = new GlassfishHttpCodecFilter(http == null || Boolean.parseBoolean(http.getXpoweredBy()), isChunkedEnabled, headerBufferLengthBytes, defaultResponseType, keepAlive, delayedExecutor, maxRequestHeaders, maxResponseHeaders);
        if (http != null) {
            httpCodecFilter.setMaxPayloadRemainderToSkip(Integer.parseInt(http.getMaxSwallowingInputBytes()));
            httpCodecFilter.setAllowPayloadForUndefinedHttpMethods(Boolean.parseBoolean(http.getAllowPayloadForUndefinedHttpMethods()));
        }
        return httpCodecFilter;
    }

    protected void registerMonitoringStatsProviders() {
        String nameLocal = this.name;
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.registerThreadPoolStatsProvider(nameLocal);
        monitoring.registerKeepAliveStatsProvider(nameLocal);
        monitoring.registerFileCacheStatsProvider(nameLocal);
        monitoring.registerConnectionQueueStatsProvider(nameLocal);
    }

    protected void unregisterMonitoringStatsProviders() {
        String localName = this.name;
        GrizzlyMonitoring monitoring = this.grizzlyService.getMonitoring();
        monitoring.unregisterThreadPoolStatsProvider(localName);
        monitoring.unregisterKeepAliveStatsProvider(localName);
        monitoring.unregisterFileCacheStatsProvider(localName);
        monitoring.unregisterConnectionQueueStatsProvider(localName);
    }

    static List<String> toArray(String s, String token) {
        String str;
        ArrayList<String> list = new ArrayList<String>();
        int from = 0;
        while (true) {
            int idx;
            if ((idx = s.indexOf(token, from)) == -1) break;
            str = s.substring(from, idx).trim();
            list.add(str);
            from = idx + 1;
        }
        str = s.substring(from, s.length()).trim();
        list.add(str);
        return list;
    }

    protected static class HttpAdapterImpl
    implements HttpAdapter {
        private final VirtualServer virtualServer;
        private final ContainerMapper conainerMapper;
        private final String webAppRootPath;

        public HttpAdapterImpl(VirtualServer virtualServer, ContainerMapper conainerMapper, String webAppRootPath) {
            this.virtualServer = virtualServer;
            this.conainerMapper = conainerMapper;
            this.webAppRootPath = webAppRootPath;
        }

        @Override
        public ContainerMapper getMapper() {
            return this.conainerMapper;
        }

        @Override
        public VirtualServer getVirtualServer() {
            return this.virtualServer;
        }

        @Override
        public String getWebAppRootPath() {
            return this.webAppRootPath;
        }
    }

    private static class GlassfishHttpCodecFilter
    extends HttpServerFilter {
        private final String serverVersion;
        private final String xPoweredBy;

        public GlassfishHttpCodecFilter(boolean isXPoweredByEnabled, boolean chunkingEnabled, int maxHeadersSize, String defaultResponseContentType, KeepAlive keepAlive, DelayedExecutor executor, int maxRequestHeaders, int maxResponseHeaders) {
            super(chunkingEnabled, maxHeadersSize, defaultResponseContentType, keepAlive, executor, maxRequestHeaders, maxResponseHeaders);
            String serverInfo = System.getProperty("product.name");
            this.serverVersion = serverInfo == null ? Version.getProductId() : (serverInfo.isEmpty() ? null : serverInfo);
            this.xPoweredBy = isXPoweredByEnabled && this.serverVersion != null ? "Servlet/6.0 JSP/3.1(" + this.serverVersion + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.specification.version") + ")" : null;
        }

        protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
            boolean result = super.onHttpHeaderParsed(httpHeader, buffer, ctx);
            HttpRequestPacket request = (HttpRequestPacket)httpHeader;
            HttpResponsePacket response = request.getResponse();
            if (this.serverVersion != null) {
                response.addHeader(Header.Server, this.serverVersion);
            }
            if (this.xPoweredBy != null) {
                response.addHeader(Header.XPoweredBy, this.xPoweredBy);
            }
            return result;
        }
    }
}

