/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic;

public enum TypeCode {
    BOOLEAN(0){

        @Override
        public String format(String s) {
            return Boolean.toString(s.equals("1"));
        }
    }
    ,
    BYTE(1),
    CHAR(2){

        @Override
        public String toValueString(Object value) {
            return value == null ? null : "L'" + this.asCharacter(value) + "'";
        }

        private String asCharacter(Object value) {
            return String.valueOf((char)((Number)value).intValue());
        }
    }
    ,
    SHORT(3),
    INT(4),
    LONG(5){

        @Override
        public String format(String s) {
            return s + "L";
        }
    }
    ,
    FLOAT(6){

        @Override
        public String format(String s) {
            return s + "F";
        }
    }
    ,
    DOUBLE(7){

        @Override
        public String format(String s) {
            return s + "D";
        }
    }
    ,
    NULL(8),
    ARRAY(9),
    CLASS(10),
    VOID(11),
    METHOD(12),
    ERROR(13);

    private int tcCode;

    public int tcCode() {
        return this.tcCode;
    }

    private TypeCode(int tcCode) {
        this.tcCode = tcCode;
    }

    String format(String s) {
        return s;
    }

    public String toValueString(Object value) {
        return value == null ? null : this.format(value.toString());
    }
}

