/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.LogLevel;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    protected int level;
    protected static SessionLog defaultLog;
    protected Session session;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static final String CONNECTION_STRING = "Connection";
    protected static final String THREAD_STRING = "Thread";
    protected Writer writer = new PrintWriter(System.out);
    protected static String DATE_FORMAT_STR;
    protected DateTimeFormatter timeStampFormatter;
    protected Boolean shouldLogExceptionStackTrace;
    protected Boolean shouldPrintDate;
    protected Boolean shouldPrintThread;
    protected Boolean shouldPrintSession;
    protected Boolean shouldPrintConnection;
    protected Boolean shouldDisplayData;

    private static String getDefaultLoggingLevelProperty() {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> System.getProperty("eclipselink.logging.level", null));
        }
        return System.getProperty("eclipselink.logging.level", null);
    }

    public static int getDefaultLoggingLevel() {
        return AbstractSessionLog.translateStringToLoggingLevel(AbstractSessionLog.getDefaultLoggingLevelProperty());
    }

    protected AbstractSessionLog() {
        this.level = AbstractSessionLog.getDefaultLoggingLevel();
    }

    @Override
    public int getLevel() {
        return this.getLevel(null);
    }

    @Override
    public String getLevelString() {
        return LogLevel.toValue(this.getLevel(), LogLevel.INFO).getName();
    }

    @Override
    public int getLevel(String category) {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.setLevel(level, null);
    }

    @Override
    public void setLevel(int level, String category) {
        this.level = level;
    }

    @Override
    public boolean shouldDisplayData() {
        if (this.shouldDisplayData != null) {
            return this.shouldDisplayData;
        }
        return this.level < 4;
    }

    @Override
    public boolean shouldLog(int level) {
        return this.shouldLog(level, null);
    }

    @Override
    public boolean shouldLog(int level, String category) {
        return this.level <= level && !this.isOff();
    }

    public static SessionLog getLog() {
        if (defaultLog == null) {
            defaultLog = new DefaultSessionLog();
        }
        return defaultLog;
    }

    public static void setLog(SessionLog sessionLog) {
        defaultLog = sessionLog;
        defaultLog.setSession(null);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public void log(int level, String message) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, (Object[])null, false);
    }

    @Override
    public void log(int level, String message, Object param) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param});
    }

    @Override
    public void log(int level, String category, String message, Object param) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(level, category, message, new Object[]{param}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2});
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2, Object param3) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2, param3});
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2, Object param3) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2, param3}, true);
    }

    @Override
    public void log(int level, String message, Object param1, Object param2, Object param3, Object param4) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, message, new Object[]{param1, param2, param3, param4});
    }

    @Override
    public void log(int level, String category, String message, Object param1, Object param2, Object param3, Object param4) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(level, category, message, new Object[]{param1, param2, param3, param4}, true);
    }

    @Override
    public void log(int level, String message, Object[] params) {
        this.log(level, message, params, true);
    }

    @Override
    public void log(int level, String category, String message, Object[] params) {
        this.log(level, category, message, params, true);
    }

    @Override
    public void log(int level, String message, Object[] params, boolean shouldTranslate) {
        if (!this.shouldLog(level)) {
            return;
        }
        this.log(new SessionLogEntry(level, null, message, params, null, shouldTranslate));
    }

    @Override
    public void log(int level, String category, String message, Object[] params, boolean shouldTranslate) {
        if (!this.shouldLog(level, category)) {
            return;
        }
        this.log(new SessionLogEntry(level, category, null, message, params, null, shouldTranslate));
    }

    @Override
    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    @Override
    public void setShouldPrintSession(boolean shouldPrintSession) {
        this.shouldPrintSession = shouldPrintSession ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection == null || this.shouldPrintConnection != false;
    }

    @Override
    public void setShouldPrintConnection(boolean shouldPrintConnection) {
        this.shouldPrintConnection = shouldPrintConnection ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean shouldLogExceptionStackTrace() {
        if (this.shouldLogExceptionStackTrace == null) {
            return this.getLevel() <= 2;
        }
        return this.shouldLogExceptionStackTrace;
    }

    @Override
    public void setShouldDisplayData(Boolean shouldDisplayData) {
        this.shouldDisplayData = shouldDisplayData;
    }

    @Override
    public void setShouldLogExceptionStackTrace(boolean shouldLogExceptionStackTrace) {
        this.shouldLogExceptionStackTrace = shouldLogExceptionStackTrace ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    @Override
    public void setShouldPrintDate(boolean shouldPrintDate) {
        this.shouldPrintDate = shouldPrintDate ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() <= 3;
        }
        return this.shouldPrintThread;
    }

    @Override
    public void setShouldPrintThread(boolean shouldPrintThread) {
        this.shouldPrintThread = shouldPrintThread ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(OutputStream outputstream) {
        this.writer = new OutputStreamWriter(outputstream);
    }

    public DateTimeFormatter getTimeStampFormatter() {
        if (this.timeStampFormatter == null) {
            this.timeStampFormatter = DateTimeFormatter.ofPattern(DATE_FORMAT_STR).withZone(ZoneId.systemDefault());
        }
        return this.timeStampFormatter;
    }

    protected String getTimeStampString(TemporalAccessor temporalAccessor) {
        if (temporalAccessor == null) {
            return null;
        }
        return this.getTimeStampFormatter().format(temporalAccessor);
    }

    protected String getSupplementDetailString(SessionLogEntry entry) {
        StringWriter writer = new StringWriter();
        if (this.shouldPrintDate()) {
            writer.write(this.getTimeStampString(entry.getTimeStamp()));
            writer.write("--");
        }
        if (this.shouldPrintSession() && entry.getSession() != null) {
            writer.write(this.getSessionString(entry.getSession()));
            writer.write("--");
        }
        if (this.shouldPrintConnection() && entry.getConnection() != null) {
            writer.write(this.getConnectionString(entry.getConnection()));
            writer.write("--");
        }
        if (this.shouldPrintThread()) {
            writer.write(this.getThreadString(entry.getThread()));
            writer.write("--");
        }
        if (entry.getSourceClassName() != null) {
            writer.write(entry.getSourceClassName());
            writer.write("--");
        }
        if (entry.getSourceMethodName() != null) {
            writer.write(entry.getSourceMethodName());
            writer.write("--");
        }
        return writer.toString();
    }

    protected String getSessionString(Session session) {
        if (session != null) {
            return session.getSessionId();
        }
        return "";
    }

    protected String getConnectionString(Accessor connection) {
        if (connection.getDatasourceConnection() == null) {
            return "Connection(" + System.identityHashCode(connection) + ")";
        }
        return "Connection(" + System.identityHashCode(connection.getDatasourceConnection()) + ")";
    }

    protected String getThreadString(Thread thread) {
        return "Thread(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int level, String category) {
        try {
            this.getWriter().write(this.getPrefixString(level, category));
        }
        catch (IOException exception) {
            throw ValidationException.logIOError(exception);
        }
    }

    protected String getPrefixString(int level, String category) {
        StringBuilder sb = new StringBuilder();
        switch (level) {
            case 7: {
                if (SEVERE_PREFIX == null) {
                    SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                }
                sb.append(SEVERE_PREFIX);
                break;
            }
            case 6: {
                if (WARNING_PREFIX == null) {
                    WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                }
                sb.append(WARNING_PREFIX);
                break;
            }
            case 5: {
                if (INFO_PREFIX == null) {
                    INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                }
                sb.append(INFO_PREFIX);
                break;
            }
            case 4: {
                if (CONFIG_PREFIX == null) {
                    CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                }
                sb.append(CONFIG_PREFIX);
                break;
            }
            case 3: {
                if (FINE_PREFIX == null) {
                    FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                }
                sb.append(FINE_PREFIX);
                break;
            }
            case 2: {
                if (FINER_PREFIX == null) {
                    FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                }
                sb.append(FINER_PREFIX);
                break;
            }
            case 1: {
                if (FINEST_PREFIX == null) {
                    FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                }
                sb.append(FINEST_PREFIX);
                break;
            }
            default: {
                if (TOPLINK_PREFIX == null) {
                    TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                }
                sb.append(TOPLINK_PREFIX);
            }
        }
        if (category != null) {
            sb.append(category);
            sb.append(": ");
        }
        return sb.toString();
    }

    public void setTimeStampFormatter(DateTimeFormatter timeStampFormatter) {
        this.timeStampFormatter = timeStampFormatter;
    }

    protected String formatMessage(SessionLogEntry entry) {
        String message = entry.getMessage();
        if (entry.shouldTranslate()) {
            message = entry.getLevel() > 3 ? LoggingLocalization.buildMessage(message, entry.getParameters()) : TraceLocalization.buildMessage(message, entry.getParameters(), true);
        } else if (entry.getParameters() != null && entry.getParameters().length > 0 && message.contains("{0")) {
            message = MessageFormat.format(message, entry.getParameters());
        }
        return message;
    }

    public static int translateStringToLoggingLevel(String loggingLevel) {
        LogLevel logLevel = LogLevel.toValue(loggingLevel);
        return logLevel != null ? logLevel.getId() : LogLevel.INFO.getId();
    }

    @Override
    public void throwing(Throwable throwable) {
        if (this.shouldLog(2)) {
            SessionLogEntry entry = new SessionLogEntry(null, throwable);
            entry.setLevel(2);
            this.log(entry);
        }
    }

    @Override
    public void severe(String message) {
        this.log(7, message, null);
    }

    @Override
    public void warning(String message) {
        this.log(6, message, null);
    }

    @Override
    public void info(String message) {
        this.log(5, message, null);
    }

    @Override
    public void config(String message) {
        this.log(4, message, null);
    }

    @Override
    public void fine(String message) {
        this.log(3, message, null);
    }

    @Override
    public void finer(String message) {
        this.log(2, message, null);
    }

    @Override
    public void finest(String message) {
        this.log(1, message, null);
    }

    @Override
    public void logThrowable(int level, Throwable throwable) {
        if (this.shouldLog(level)) {
            this.log(new SessionLogEntry(null, level, null, throwable));
        }
    }

    @Override
    public void logThrowable(int level, String category, Throwable throwable) {
        if (this.shouldLog(level, category)) {
            this.log(new SessionLogEntry(null, level, category, throwable));
        }
    }

    public boolean isOff() {
        return this.level == 8;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static String translateLoggingLevelToString(int loggingLevel) {
        return LogLevel.toValue(loggingLevel, LogLevel.INFO).getName();
    }

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        DATE_FORMAT_STR = "yyyy.MM.dd HH:mm:ss.SSS";
    }
}

