/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.interactions;

import jakarta.resource.cci.Record;
import java.io.StringWriter;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.w3c.dom.Element;

public class XMLInteraction
extends MappedInteraction {
    protected String inputRootElementName = "";
    protected String outputRootElementName = "";

    public String getInputRootElementName() {
        return this.inputRootElementName;
    }

    public void setInputRootElementName(String inputRootElementName) {
        this.inputRootElementName = inputRootElementName;
    }

    public String getOutputRootElementName() {
        return this.outputRootElementName;
    }

    public void setOutputRootElementName(String outputRootElementName) {
        this.outputRootElementName = outputRootElementName;
    }

    @Override
    public void prepare(AbstractSession session) {
        EISDescriptor descriptor;
        ClassDescriptor desc;
        DatabaseQuery q = this.getQuery();
        ClassDescriptor classDescriptor = desc = q != null ? q.getDescriptor() : null;
        if (this.getInputRootElementName().isEmpty()) {
            if (desc != null && desc.isEISDescriptor()) {
                descriptor = (EISDescriptor)desc;
                this.setInputRootElementName(descriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("input");
            }
        }
        if (this.getOutputRootElementName().isEmpty()) {
            if (desc != null && desc.isEISDescriptor()) {
                descriptor = (EISDescriptor)desc;
                this.setOutputRootElementName(descriptor.getDataTypeName());
            } else {
                this.setInputRootElementName("output");
            }
        }
        super.prepare(session);
    }

    @Override
    public Record createInputRecord(EISAccessor accessor) {
        Record record = accessor.getEISPlatform().createDOMRecord(this.getInputRecordName(), accessor);
        Element dom = this.createInputDOM(accessor);
        accessor.getEISPlatform().setDOMInRecord(dom, record, this, accessor);
        if (record instanceof XMLRecord) {
            ((XMLRecord)record).setSession(this.getQuery().getSession());
        }
        return record;
    }

    public Element createInputDOM(EISAccessor accessor) {
        Element dom = null;
        if (this.getInputRow() != null && !this.hasArguments()) {
            if (this.getInputResultPath().isEmpty()) {
                if (this.getInputRow() instanceof XMLRecord) {
                    dom = (Element)((XMLRecord)this.getInputRow()).getDOM();
                    if (!dom.getTagName().equals(this.getInputRootElementName())) {
                        XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                        parameterRow.put("/" + this.getInputRootElementName(), (Object)this.getInputRow());
                        dom = (Element)parameterRow.getDOM();
                    }
                } else {
                    XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                    for (int index = 0; index < this.getInputRow().size(); ++index) {
                        parameterRow.put(this.getInputRow().getFields().get(index), this.getInputRow().getValues().get(index));
                    }
                    dom = (Element)parameterRow.getDOM();
                }
            } else {
                XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
                parameterRow.put(this.getInputResultPath(), (Object)this.getInputRow());
                dom = (Element)parameterRow.getDOM();
            }
        } else {
            XMLRecord parameterRow = this.createXMLRecord(this.getInputRootElementName());
            for (int index = 0; index < this.getArgumentNames().size(); ++index) {
                String parameterName = this.getArgumentNames().get(index);
                Object parameter = this.getParameters().get(index);
                if (parameter == null && this.getInputRow() != null) {
                    parameter = this.getInputRow().get(parameterName);
                }
                parameterRow.put(parameterName, parameter);
            }
            dom = (Element)parameterRow.getDOM();
        }
        return dom;
    }

    @Override
    public AbstractRecord buildRow(Record record, EISAccessor accessor) {
        if (record == null) {
            return null;
        }
        AbstractRecord row = accessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, accessor);
        if (row == null) {
            return null;
        }
        if (!this.getOutputResultPath().isEmpty()) {
            row = (AbstractRecord)row.get(this.getOutputResultPath());
        } else if (this.hasOutputArguments()) {
            row = this.createXMLRecord(this.getOutputRootElementName());
            for (int index = 0; index < this.getOutputArgumentNames().size(); ++index) {
                DatabaseField field = this.getOutputArguments().get(index);
                row.put(field, row.get(this.getOutputArgumentNames().get(index)));
            }
        }
        return row;
    }

    @Override
    public Vector<AbstractRecord> buildRows(Record record, EISAccessor accessor) {
        Vector<AbstractRecord> rows = null;
        if (record == null) {
            return new Vector<AbstractRecord>(0);
        }
        AbstractRecord row = accessor.getEISPlatform().createDatabaseRowFromDOMRecord(record, this, accessor);
        if (!this.getOutputResultPath().isEmpty()) {
            Vector<AbstractRecord> values = (Vector<AbstractRecord>)row.getValues(this.getOutputResultPath());
            if (values == null) {
                values = new Vector<AbstractRecord>(0);
            }
            rows = values;
        } else {
            rows = new Vector<AbstractRecord>(1);
            rows.add(row);
        }
        return rows;
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringWriter writer = new StringWriter();
        writer.write("Executing ");
        writer.write(this.toString());
        writer.write(System.lineSeparator());
        writer.write("\tspec => ");
        writer.write(String.valueOf(this.getInteractionSpec()));
        writer.write(System.lineSeparator());
        writer.write("\tproperties => ");
        writer.write(String.valueOf(this.getProperties()));
        writer.write(System.lineSeparator());
        writer.write("\txml => ");
        Element dom = this.createInputDOM((EISAccessor)accessor);
        EISDOMRecord record = new EISDOMRecord(dom);
        record.transformToWriter(writer);
        return writer.toString();
    }

    @Override
    protected DatabaseField createField(String fieldName) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().buildField(fieldName);
        }
        return new XMLField(fieldName);
    }

    protected XMLRecord createXMLRecord(String rootName) {
        XMLRecord xmlRec;
        ClassDescriptor descriptor = this.getQuery().getDescriptor();
        if (descriptor != null && descriptor.isEISDescriptor() && descriptor.getObjectBuilder().isXMLObjectBuilder()) {
            xmlRec = (XMLRecord)((XMLObjectBuilder)descriptor.getObjectBuilder()).createRecord(this.getInputRootElementName(), this.getQuery().getSession());
        } else {
            xmlRec = new DOMRecord(this.getInputRootElementName());
            ((XMLRecord)xmlRec).setSession(this.getQuery().getSession());
        }
        return xmlRec;
    }
}

