/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.HashMap;
import java.util.Map;

public class MetadataAnnotation {
    protected String m_name;
    protected boolean isMeta = false;
    protected Map<String, Object> m_attributes = new HashMap<String, Object>();

    public void addAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    private Object getAttribute(String name) {
        return this.m_attributes.get(name);
    }

    public MetadataAnnotation getAttributeAnnotation(String name) {
        Object value = this.getAttribute(name);
        return value == null ? null : (MetadataAnnotation)value;
    }

    public Object[] getAttributeArray(String name) {
        Object value = this.getAttribute(name);
        return value == null ? new Object[]{} : (Object[])value;
    }

    public Boolean getAttributeBoolean(String name, Boolean defaultValue) {
        Object value = this.getAttribute(name);
        return value == null ? defaultValue : (Boolean)value;
    }

    public Boolean getAttributeBooleanDefaultFalse(String name) {
        return this.getAttributeBoolean(name, Boolean.FALSE);
    }

    public Boolean getAttributeBooleanDefaultTrue(String name) {
        return this.getAttributeBoolean(name, Boolean.TRUE);
    }

    public String getAttributeClass(String name, Class<?> defaultClass) {
        Object value = this.getAttribute(name);
        return value == null ? defaultClass.getName() : (String)value;
    }

    public Integer getAttributeInteger(String name) {
        Object value = this.getAttribute(name);
        return value == null ? null : (Integer)value;
    }

    public Map<String, Object> getAttributes() {
        return this.m_attributes;
    }

    public String getAttributeString(String name) {
        return (String)this.getAttribute(name);
    }

    public String getAttributeString(String name, String defaultValue) {
        Object value = this.getAttribute(name);
        return value == null ? defaultValue : (String)value;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.m_attributes = attributes;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setIsMeta(boolean isMeta) {
        this.isMeta = isMeta;
    }

    public boolean isMeta() {
        return this.isMeta;
    }

    public String toString() {
        return "@" + this.getName() + "(" + String.valueOf(this.m_attributes) + ")";
    }
}

