/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.interceptor.Interceptor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceUnit;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.weld.DeploymentImpl;
import org.glassfish.weld.connector.WeldUtils;
import org.glassfish.weld.services.WsInjectionHandler;
import org.jboss.weld.injection.spi.InjectionContext;
import org.jboss.weld.injection.spi.InjectionServices;

public class InjectionServicesImpl
implements InjectionServices {
    private final InjectionManager injectionManager;
    private final BundleDescriptor bundleContext;
    private final DeploymentImpl deployment;
    private WsInjectionHandler wsHandler;

    public InjectionServicesImpl(InjectionManager injectionMgr, BundleDescriptor context, DeploymentImpl deployment) {
        this.injectionManager = injectionMgr;
        this.bundleContext = context;
        this.deployment = deployment;
    }

    private boolean isInterceptor(Class beanClass) {
        HashSet<String> annos = new HashSet<String>();
        annos.add(Interceptor.class.getName());
        boolean res = false;
        while (!res && beanClass != Object.class) {
            res = WeldUtils.hasValidAnnotation((Class)beanClass, annos, null);
            beanClass = beanClass.getSuperclass();
        }
        return res;
    }

    public <T> void aroundInject(InjectionContext<T> injectionContext) {
        try {
            ServiceLocator serviceLocator = Globals.getDefaultHabitat();
            ComponentEnvManager compEnvManager = (ComponentEnvManager)serviceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
            EjbContainerServices containerServices = (EjbContainerServices)serviceLocator.getService(EjbContainerServices.class, new Annotation[0]);
            JndiNameEnvironment componentEnv = compEnvManager.getCurrentJndiNameEnvironment();
            ManagedBeanDescriptor mbDesc = null;
            JndiNameEnvironment injectionEnv = (JndiNameEnvironment)this.bundleContext;
            AnnotatedType annotatedType = injectionContext.getAnnotatedType();
            Class targetClass = annotatedType.getJavaClass();
            String targetClassName = targetClass.getName();
            Object target = injectionContext.getTarget();
            if (this.isInterceptor(targetClass) && !componentEnv.equals(injectionEnv)) {
                this.injectionManager.inject(targetClass, target, injectionEnv, null, false);
            } else {
                if (componentEnv == null) {
                    System.err.println("No valid EE environment for injection of " + targetClassName);
                    injectionContext.proceed();
                    return;
                }
                if (componentEnv instanceof EjbDescriptor) {
                    EjbDescriptor ejbDesc = (EjbDescriptor)componentEnv;
                    if (containerServices.isEjbManagedObject((Object)ejbDesc, targetClass)) {
                        injectionEnv = componentEnv;
                    } else if (this.bundleContext instanceof EjbBundleDescriptor) {
                        mbDesc = this.bundleContext.getManagedBeanByBeanClass(targetClassName);
                    }
                }
                if (mbDesc != null) {
                    componentId = mbDesc.getGlobalJndiName();
                    this.injectionManager.injectInstance(target, componentId, false);
                } else if (injectionEnv instanceof EjbBundleDescriptor) {
                    componentId = SimpleJndiName.of((String)compEnvManager.getComponentEnvId(injectionEnv));
                    if (target == null) {
                        this.injectionManager.injectClass(targetClass, componentId, false);
                    } else {
                        this.injectionManager.injectInstance(target, componentId, false);
                    }
                } else if (target == null) {
                    this.injectionManager.injectClass(targetClass, injectionEnv, false);
                } else {
                    this.injectionManager.injectInstance(target, injectionEnv, false);
                }
            }
            injectionContext.proceed();
        }
        catch (InjectionException ie) {
            throw new IllegalStateException(ie.getMessage(), ie);
        }
    }

    public <T> void registerInjectionTarget(InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType) {
        if (this.bundleContext instanceof EjbBundleDescriptor) {
            return;
        }
        Class annotatedClass = annotatedType.getJavaClass();
        JndiNameEnvironment jndiNameEnvironment = (JndiNameEnvironment)this.bundleContext;
        InjectionInfo injectionInfo = jndiNameEnvironment.getInjectionInfoByClass(annotatedClass);
        List injectionResources = injectionInfo.getInjectionResources();
        for (AnnotatedField annotatedField : annotatedType.getFields()) {
            if (!annotatedField.isAnnotationPresent(Produces.class)) continue;
            if (annotatedField.isAnnotationPresent(EJB.class)) {
                this.validateEjbProducer(annotatedClass, annotatedField, injectionResources);
                continue;
            }
            if (annotatedField.isAnnotationPresent(Resource.class)) {
                this.validateResourceProducer(annotatedClass, annotatedField, injectionResources);
                continue;
            }
            if (annotatedField.isAnnotationPresent(PersistenceUnit.class)) {
                this.validateResourceClass(annotatedField, EntityManagerFactory.class);
                continue;
            }
            if (annotatedField.isAnnotationPresent(PersistenceContext.class)) {
                this.validateResourceClass(annotatedField, EntityManager.class);
                continue;
            }
            if (!this.getWsHandler().handles(annotatedField)) continue;
            this.getWsHandler().validateWebServiceRef(annotatedField);
        }
    }

    private <T> void validateEjbProducer(Class<T> annotatedClass, AnnotatedField<?> annotatedField, List<InjectionCapable> injectionResources) {
        EJB ejbAnnotation = (EJB)annotatedField.getAnnotation(EJB.class);
        if (ejbAnnotation != null) {
            SimpleJndiName lookupName = this.getLookupName(annotatedClass, annotatedField, injectionResources);
            EjbDescriptor foundEjb = null;
            Collection<EjbDescriptor> ejbs = this.deployment.getDeployedEjbs();
            for (EjbDescriptor oneEjb : ejbs) {
                SimpleJndiName jndiName = oneEjb.getJndiName();
                if (!lookupName.contains(jndiName.toString())) continue;
                foundEjb = oneEjb;
                break;
            }
            if (foundEjb != null) {
                String className = foundEjb.getEjbImplClassName();
                try {
                    Class<?> clazz = Class.forName(className, false, annotatedClass.getClassLoader());
                    this.validateResourceClass(annotatedField, clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateResourceProducer(Class<?> annotatedClass, AnnotatedField annotatedField, List<InjectionCapable> injectionResources) {
        Resource resourceAnnotation = (Resource)annotatedField.getAnnotation(Resource.class);
        if (resourceAnnotation != null) {
            SimpleJndiName lookupName = this.getLookupName(annotatedClass, annotatedField, injectionResources);
            if (lookupName.toString().equals("java:comp/BeanManager")) {
                this.validateResourceClass(annotatedField, BeanManager.class);
            } else {
                boolean done = false;
                block5: for (InjectionCapable injectionCapable : injectionResources) {
                    for (com.sun.enterprise.deployment.InjectionTarget target : injectionCapable.getInjectionTargets()) {
                        if (target.isFieldInjectable() && annotatedClass.getName().equals(target.getClassName()) && target.getFieldName().equals(annotatedField.getJavaMember().getName())) {
                            String type = injectionCapable.getInjectResourceType();
                            try {
                                Class<?> clazz = Class.forName(type, false, annotatedClass.getClassLoader());
                                this.validateResourceClass(annotatedField, clazz);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                            }
                            finally {
                                done = true;
                            }
                        }
                        if (!done) continue;
                        continue block5;
                    }
                }
            }
        }
    }

    private void validateResourceClass(AnnotatedField annotatedField, Class resourceClass) {
        if (!annotatedField.getJavaMember().getType().isAssignableFrom(resourceClass)) {
            this.throwProducerDefinitionExeption(annotatedField.getJavaMember().getName(), annotatedField.getJavaMember().getType().getName(), resourceClass.getName());
        }
    }

    private void throwProducerDefinitionExeption(String annotatedFieldName, String annotatedFieldType, String resourceClassName) {
        throw new DefinitionException("The type of the injection point " + annotatedFieldName + " is " + annotatedFieldType + ".  The type of the physical resource is " + resourceClassName + " They are incompatible. ");
    }

    private SimpleJndiName getComponentEnvName(Class annotatedClass, String fieldName, List<InjectionCapable> injectionResources) {
        for (InjectionCapable injectionCapable : injectionResources) {
            for (com.sun.enterprise.deployment.InjectionTarget target : injectionCapable.getInjectionTargets()) {
                if (!target.isFieldInjectable() || !annotatedClass.getName().equals(target.getClassName()) || !target.getFieldName().equals(fieldName)) continue;
                SimpleJndiName name = injectionCapable.getComponentEnvName();
                if (!name.hasJavaPrefix()) {
                    name = new SimpleJndiName("java:comp/env/" + String.valueOf(name));
                }
                return name;
            }
        }
        return null;
    }

    private SimpleJndiName getLookupName(Class annotatedClass, AnnotatedField annotatedField, List<InjectionCapable> injectionResources) {
        SimpleJndiName lookupName = null;
        if (annotatedField.isAnnotationPresent(Resource.class)) {
            Resource resource = (Resource)annotatedField.getAnnotation(Resource.class);
            lookupName = InjectionServicesImpl.getJndiName(resource.lookup(), resource.mappedName(), resource.name());
        } else if (annotatedField.isAnnotationPresent(EJB.class)) {
            EJB ejb = (EJB)annotatedField.getAnnotation(EJB.class);
            lookupName = InjectionServicesImpl.getJndiName(ejb.lookup(), ejb.mappedName(), ejb.name());
        } else if (this.getWsHandler().handles(annotatedField)) {
            lookupName = this.getWsHandler().getJndiName(annotatedField);
        } else if (annotatedField.isAnnotationPresent(PersistenceUnit.class)) {
            PersistenceUnit persistenceUnit = (PersistenceUnit)annotatedField.getAnnotation(PersistenceUnit.class);
            lookupName = InjectionServicesImpl.getJndiName(persistenceUnit.unitName(), null, persistenceUnit.name());
        } else if (annotatedField.isAnnotationPresent(PersistenceContext.class)) {
            PersistenceContext persistenceContext = (PersistenceContext)annotatedField.getAnnotation(PersistenceContext.class);
            lookupName = InjectionServicesImpl.getJndiName(persistenceContext.unitName(), null, persistenceContext.name());
        }
        if (lookupName == null || lookupName.isEmpty()) {
            lookupName = this.getComponentEnvName(annotatedClass, annotatedField.getJavaMember().getName(), injectionResources);
        }
        return lookupName;
    }

    static SimpleJndiName getJndiName(String lookup, String mappedName, String name) {
        String jndiName = lookup;
        if ((jndiName == null || jndiName.isEmpty()) && ((jndiName = mappedName) == null || jndiName.isEmpty())) {
            jndiName = name;
        }
        return jndiName == null ? null : new SimpleJndiName(jndiName.trim());
    }

    private WsInjectionHandler getWsHandler() {
        if (this.wsHandler == null) {
            try {
                this.wsHandler = (WsInjectionHandler)Class.forName("org.glassfish.weld.services.WsInjectionHandlerImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException t) {
                this.wsHandler = WsInjectionHandler.NOOP;
            }
        }
        return this.wsHandler;
    }

    public void cleanup() {
    }
}

