/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.core.queries.CoreMappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class MappedKeyMapContainerPolicy
extends MapContainerPolicy
implements CoreMappedKeyMapContainerPolicy<AbstractSession> {
    protected MapKeyMapping keyMapping;
    protected MapComponentMapping valueMapping;
    public DatabaseQuery keyQuery;

    public MappedKeyMapContainerPolicy() {
    }

    public MappedKeyMapContainerPolicy(Class<?> containerClass) {
        super(containerClass);
    }

    public MappedKeyMapContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
        this.keyMapping.addAdditionalFieldsToQuery(selectionQuery, baseExpression);
    }

    @Override
    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession session) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isReadOnly()) {
            return null;
        }
        Object keyValue = ((Map.Entry)object).getKey();
        return this.keyMapping.extractIdentityFieldsForQuery(keyValue, session);
    }

    @Override
    public Object getKeyType() {
        return this.keyMapping.getMapKeyTargetType();
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord joinRow) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isReadOnly()) {
            return;
        }
        this.keyMapping.addFieldsForMapKey(joinRow);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session) {
        if (element instanceof Map.Entry) {
            Map.Entry record = (Map.Entry)element;
            Object key = record.getKey();
            Object value = record.getValue();
            return this.addInto(key, value, container, session);
        }
        throw QueryException.cannotAddToContainer(element, container, this);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord row, DataReadQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        Object key = this.keyMapping.createMapComponentFromRow(row, null, parentCacheKey, session, isTargetProtected);
        Object value = this.valueMapping.createMapComponentFromRow(row, null, parentCacheKey, session, isTargetProtected);
        return this.addInto(key, value, container, session);
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        Object key = null;
        Object value = null;
        if (this.valueMapping != null && ((DatabaseMapping)((Object)this.valueMapping)).isDirectCollectionMapping() && session.getDescriptor((Class)element.getClass()) != null) {
            key = element;
            value = this.valueMapping.createMapComponentFromRow(dbRow, null, parentCacheKey, session, isTargetProtected);
        } else if (this.keyMapping != null) {
            value = element;
            try {
                key = this.keyMapping.createMapComponentFromRow(dbRow, query, parentCacheKey, session, isTargetProtected);
            }
            catch (Exception e) {
                throw QueryException.exceptionWhileReadingMapKey(element, e);
            }
        }
        return this.addInto(key, value, container, session);
    }

    @Override
    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
        ObjectLevelReadQuery nestedQuery = this.keyMapping.getNestedJoinQuery(joinManager, query, session);
        if (nestedQuery != null) {
            joinManager.getJoinedMappingQueries_().put((DatabaseMapping)((Object)this.keyMapping), nestedQuery);
        }
    }

    @Override
    public Object buildCloneForKey(Object key, Object parent, CacheKey parentCacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isCacheCheckComplete) {
        return this.keyMapping.buildElementClone(key, parent, parentCacheKey, refreshCascade, cloningSession, isExisting, isCacheCheckComplete);
    }

    @Override
    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        ReadQuery query = this.keyMapping.buildSelectionQueryForDirectCollectionKeyMapping(this);
        return query;
    }

    @Override
    public Object buildKey(AbstractRecord row, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.keyMapping.createMapComponentFromRow(row, query, parentCacheKey, session, isTargetProtected);
    }

    @Override
    public Object buildKeyFromJoinedRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return this.keyMapping.createMapComponentFromJoinedRow(row, joinManager, query, parentCacheKey, session, isTargetProtected);
    }

    @Override
    public Object[] buildReferencesPKList(Object container, AbstractSession session) {
        Object[] result = new Object[this.sizeFor(container) * 2];
        Iterator iterator = (Iterator)this.iteratorFor(container);
        boolean isElementCollection = ((DatabaseMapping)((Object)this.valueMapping)).isElementCollectionMapping();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            result[index] = this.keyMapping.createSerializableMapKeyInfo(entry.getKey(), session);
            result[++index] = isElementCollection ? entry.getValue() : this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(entry.getValue(), session);
            ++index;
        }
        return result;
    }

    @Override
    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
        this.keyMapping.cascadeDiscoverAndPersistUnregisteredNewObjects(((Map.Entry)object).getKey(), newObjects, unregisteredExistingObjects, visitedObjects, uow, false, cascadeErrors);
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.keyMapping.cascadePerformRemoveIfRequired(((Map.Entry)object).getKey(), uow, visitedObjects, false);
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        this.keyMapping.cascadeRegisterNewIfRequired(((Map.Entry)object).getKey(), uow, visitedObjects, false);
    }

    @Override
    public Object clone() {
        MappedKeyMapContainerPolicy clone = (MappedKeyMapContainerPolicy)super.clone();
        clone.keyMapping = (MapKeyMapping)this.keyMapping.clone();
        if (this.keyQuery != null) {
            clone.keyQuery = (DatabaseQuery)this.keyQuery.clone();
        }
        return clone;
    }

    public boolean compareContainers(Object firstObjectMap, Object secondObjectMap) {
        if (this.sizeFor(firstObjectMap) != this.sizeFor(secondObjectMap)) {
            return false;
        }
        Object firstIterator = this.iteratorFor(firstObjectMap);
        while (this.hasNext(firstIterator)) {
            Map.Entry entry = (Map.Entry)this.nextEntry(firstIterator);
            Object key = entry.getKey();
            if (((Map)firstObjectMap).get(key).equals(((Map)secondObjectMap).get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        if (this.keyMapping != null) {
            return true;
        }
        return super.compareKeys(sourceValue, session);
    }

    @Override
    protected void createChangeSetForKeys(Map originalKeyValues, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        for (Association association : originalKeyValues.values()) {
            Object object = association.getValue();
            ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
            changeSet.setOldKey(association.getKey());
        }
    }

    @Override
    public QueryKey createQueryKeyForMapKey() {
        return this.keyMapping.createQueryKeyForMapKey();
    }

    @Override
    public Object createWrappedObjectFromExistingWrappedObject(Object wrappedObject, Object parent, ClassDescriptor referenceDescriptor, MergeManager mergeManager, AbstractSession targetSession) {
        Object key = ((Map.Entry)wrappedObject).getKey();
        key = this.keyMapping.getTargetVersionOfSourceObject(key, parent, mergeManager, targetSession);
        key = this.keyMapping.wrapKey(key, mergeManager.getSession());
        Object value = referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(wrappedObject), referenceDescriptor, targetSession), mergeManager.getSession());
        return new Association(key, value);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        ((DatabaseMapping)((Object)this.keyMapping)).convertClassNamesToClasses(classLoader);
    }

    @Override
    public void deleteWrappedObject(Object objectDeleted, AbstractSession session) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            this.keyMapping.deleteMapKey(((Map.Entry)objectDeleted).getKey(), session);
        }
        session.deleteObject(this.unwrapIteratorResult(objectDeleted));
    }

    @Override
    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return this.keyMapping.getAdditionalTablesForJoinQuery();
    }

    @Override
    public List<DatabaseField> getAdditionalFieldsForJoin(CollectionMapping baseMapping) {
        return this.keyMapping.getAllFieldsForMapKey();
    }

    public Map<DatabaseField, DatabaseField> getForeignKeyFieldsForMapKey() {
        return this.keyMapping.getForeignKeyFieldsForMapKey();
    }

    @Override
    public ClassDescriptor getDescriptorForMapKey() {
        return this.keyMapping.getReferenceDescriptor();
    }

    @Override
    public Object getCloneDataFromChangeSet(ObjectChangeSet changeSet) {
        Object key = changeSet.getNewKey();
        if (key == null) {
            key = changeSet.getOldKey();
        }
        return new Association(key, changeSet.getUnitOfWorkClone());
    }

    @Override
    public DatabaseField getDirectKeyField(CollectionMapping baseMapping) {
        if (this.keyMapping != null && ((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)this.keyMapping).getField();
        }
        return null;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return this.keyMapping.getIdentityFieldsForMapKey();
    }

    public Converter getKeyConverter() {
        if (this.keyMapping != null && ((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            return ((AbstractDirectMapping)this.keyMapping).getConverter();
        }
        return null;
    }

    public MapKeyMapping getKeyMapping() {
        return this.keyMapping;
    }

    public DatabaseQuery getKeyQuery() {
        return this.keyQuery;
    }

    @Override
    public Expression getKeySelectionCriteria() {
        return this.keyMapping.getAdditionalSelectionCriteriaForMapKey();
    }

    public MapComponentMapping getValueMapping() {
        return this.valueMapping;
    }

    @Override
    public void initialize(AbstractSession session, DatabaseTable keyTable) {
        this.getKeyMapping().preinitializeMapKey(keyTable);
        ((DatabaseMapping)((Object)this.keyMapping)).initialize(session);
    }

    @Override
    protected boolean isKeyAvailableFromElement() {
        return false;
    }

    @Override
    public boolean isMappedKeyMapPolicy() {
        return true;
    }

    @Override
    public boolean isMapKeyAttribute() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isAbstractDirectMapping();
    }

    @Override
    public boolean isMapKeyObject() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isOneToOneMapping();
    }

    @Override
    public void iterateOnMapKey(DescriptorIterator iterator, Object element) {
        Object key = ((Map.Entry)element).getKey();
        this.keyMapping.iterateOnMapKey(iterator, key);
    }

    @Override
    public void postCalculateChanges(ObjectChangeSet ocs, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.getKeyMapping())).isForeignReferenceMapping() && ((DatabaseMapping)((Object)this.getKeyMapping())).isPrivateOwned()) {
            Object key = ocs.getOldKey();
            uow.addDeletedPrivateOwnedObjects((DatabaseMapping)((Object)this.getKeyMapping()), key);
        }
        super.postCalculateChanges(ocs, referenceDescriptor, mapping, uow);
    }

    @Override
    public void postCalculateChanges(Object key, Object value, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.getKeyMapping())).isForeignReferenceMapping() && ((DatabaseMapping)((Object)this.getKeyMapping())).isPrivateOwned()) {
            uow.addDeletedPrivateOwnedObjects((DatabaseMapping)((Object)this.getKeyMapping()), key);
        }
        super.postCalculateChanges(key, value, referenceDescriptor, mapping, uow);
    }

    @Override
    public void processAdditionalWritableMapKeyFields(AbstractSession session) {
        if (!((DatabaseMapping)((Object)this.getKeyMapping())).isReadOnly() && this.valueMapping instanceof CollectionMapping) {
            CollectionMapping mapping = (CollectionMapping)((Object)this.valueMapping);
            for (DatabaseField field : this.getIdentityFieldsForMapKey()) {
                if (mapping.getReferenceDescriptor().getObjectBuilder().getMappingsByField().containsKey(field) || mapping.getReferenceDescriptor().getAdditionalWritableMapKeyFields().contains(field)) {
                    session.getIntegrityChecker().handleError(DescriptorException.multipleWriteMappingsForField(field.toString(), mapping));
                    continue;
                }
                mapping.getReferenceDescriptor().getAdditionalWritableMapKeyFields().add(field);
            }
        }
    }

    @Override
    public void recordPrivateOwnedRemovals(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkImpl uow) {
        if (((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned()) {
            Object key = ((Map.Entry)object).getKey();
            ((DatabaseMapping)((Object)this.keyMapping)).getReferenceDescriptor().getObjectBuilder().recordPrivateOwnedRemovals(key, uow, false);
        }
        super.recordPrivateOwnedRemovals(((Map.Entry)object).getValue(), referenceDescriptor, uow);
    }

    @Override
    public boolean requiresDataModificationEvents() {
        return this.keyMapping.requiresDataModificationEventsForMapKey();
    }

    @Override
    public Object keyFrom(Object element, AbstractSession session) {
        if (this.keyMapping != null) {
            return null;
        }
        return super.keyFrom(element, session);
    }

    @Override
    public void postInitialize(AbstractSession session) {
        ((DatabaseMapping)((Object)this.keyMapping)).postInitialize(session);
        this.keyMapping.postInitializeMapKey(this);
    }

    @Override
    public void propogatePostDelete(DeleteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).postDeleteAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePostInsert(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).postInsertAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePostUpdate(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            Object key = object;
            if (object instanceof Map.Entry) {
                key = ((Map.Entry)object).getKey();
            }
            ((AggregateObjectMapping)this.keyMapping).postUpdateAttributeValue(query, key);
        }
    }

    @Override
    public void propogatePreDelete(DeleteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preDeleteAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePreInsert(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preInsertAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public void propogatePreUpdate(WriteObjectQuery query, Object object) {
        if (this.propagatesEventsToCollection()) {
            ((AggregateObjectMapping)this.keyMapping).preUpdateAttributeValue(query, ((Map.Entry)object).getKey());
        }
    }

    @Override
    public boolean propagatesEventsToCollection() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isAggregateObjectMapping();
    }

    public void setKeyField(DatabaseField keyField, ClassDescriptor descriptor) {
        if (this.keyMapping == null) {
            DirectToFieldMapping newKeyMapping = new DirectToFieldMapping();
            newKeyMapping.setField(keyField);
            newKeyMapping.setDescriptor(descriptor);
            this.setKeyMapping(newKeyMapping);
        }
        if (((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            ((AbstractDirectMapping)this.keyMapping).setField(keyField);
        }
    }

    public void setDescriptorForKeyMapping(ClassDescriptor descriptor) {
        ((DatabaseMapping)((Object)this.keyMapping)).setDescriptor(descriptor);
    }

    public void setKeyConverter(Converter keyConverter, DirectMapMapping mapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(mapping.getDescriptor(), mapping, keyConverter.getClass().getName());
        }
        ((AbstractDirectMapping)this.keyMapping).setConverter(keyConverter);
    }

    public void setKeyConverterClassName(String keyConverterClassName, DirectMapMapping mapping) {
        if (!((DatabaseMapping)((Object)this.keyMapping)).isDirectToFieldMapping()) {
            throw DescriptorException.cannotSetConverterForNonDirectMapping(mapping.getDescriptor(), mapping, keyConverterClassName);
        }
        ((AbstractDirectMapping)this.keyMapping).setConverterClassName(keyConverterClassName);
    }

    public void setKeyMapping(MapKeyMapping mapping) {
        if (((DatabaseMapping)((Object)mapping)).isForeignReferenceMapping() && ((ForeignReferenceMapping)((Object)mapping)).getIndirectionPolicy().usesIndirection()) {
            throw ValidationException.mapKeyCannotUseIndirection((DatabaseMapping)((Object)mapping));
        }
        this.keyMapping = mapping;
        ((DatabaseMapping)((Object)mapping)).setIsMapKeyMapping(true);
    }

    public void setKeyQuery(DatabaseQuery keyQuery) {
        this.keyQuery = keyQuery;
    }

    public void setValueMapping(MapComponentMapping mapping) {
        this.valueMapping = mapping;
    }

    @Override
    public boolean shouldIncludeKeyInDeleteEvent() {
        return ((DatabaseMapping)((Object)this.keyMapping)).isPrivateOwned();
    }

    @Override
    public boolean shouldUpdateForeignKeysPostInsert() {
        return !((DatabaseMapping)((Object)this.keyMapping)).isReadOnly();
    }

    @Override
    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        indexList.put((DatabaseMapping)((Object)this.keyMapping), index);
        return this.getAdditionalFieldsForJoin(null).size();
    }

    @Override
    public Object unwrapKey(Object key, AbstractSession session) {
        return this.keyMapping.unwrapKey(key, session);
    }

    @Override
    public Object valueFromPKList(Object[] pks, AbstractRecord foreignKeys, ForeignReferenceMapping mapping, AbstractSession session) {
        int mapSize = pks.length / 2;
        Object result = this.containerInstance(mapSize);
        Object[] keys = new Object[mapSize];
        Object[] values = new Object[mapSize];
        for (int index = 0; index < pks.length; ++index) {
            keys[index / 2] = pks[index];
            values[++index / 2] = pks[index];
        }
        List<Object> keyObjects = this.keyMapping.createMapComponentsFromSerializableKeyInfo(keys, session);
        if (((DatabaseMapping)((Object)this.valueMapping)).isElementCollectionMapping()) {
            for (int i = 0; i < mapSize; ++i) {
                this.addInto(keyObjects.get(i), values[i], result, session);
            }
        } else {
            Map<Object, Object> fromCache = session.getIdentityMapAccessorInstance().getAllFromIdentityMapWithEntityPK(values, this.elementDescriptor);
            List foreignKeyValues = new ArrayList<Object>(pks.length - fromCache.size());
            CacheKeyType cacheKeyType = this.elementDescriptor.getCachePolicy().getCacheKeyType();
            for (int index = 0; index < mapSize; ++index) {
                Object pk = values[index];
                if (fromCache.containsKey(pk)) continue;
                if (cacheKeyType == CacheKeyType.CACHE_ID) {
                    foreignKeyValues.add(Arrays.asList(((CacheId)pk).getPrimaryKey()));
                    continue;
                }
                foreignKeyValues.add(pk);
            }
            if (!foreignKeyValues.isEmpty()) {
                if (foreignKeyValues.size() == pks.length) {
                    return session.executeQuery((DatabaseQuery)mapping.getSelectionQuery(), foreignKeys);
                }
                ReadAllQuery query = new ReadAllQuery(this.elementDescriptor.getJavaClass());
                query.setIsExecutionClone(true);
                query.addArgument("query-batch-parameter");
                query.setSession(session);
                query.setSelectionCriteria(this.elementDescriptor.buildBatchCriteriaByPK(query.getExpressionBuilder(), query));
                int pkCount = foreignKeyValues.size();
                ArrayList temp = new ArrayList();
                ArrayList<Object> arguments = new ArrayList<Object>();
                arguments.add(foreignKeyValues);
                if (pkCount > 1000) {
                    int index = 0;
                    while (index + 1000 < pkCount) {
                        ArrayList pkList = new ArrayList();
                        pkList.addAll(foreignKeyValues.subList(index, index + 1000));
                        arguments.set(0, pkList);
                        query.setArgumentValues(arguments);
                        temp.addAll((Collection)session.executeQuery(query));
                        index += 1000;
                    }
                    foreignKeyValues = foreignKeyValues.subList(index, pkCount);
                }
                arguments.set(0, foreignKeyValues);
                query.setArgumentValues(arguments);
                temp.addAll((Collection)session.executeQuery(query));
                if (temp.size() < pkCount) {
                    return session.executeQuery((DatabaseQuery)mapping.getSelectionQuery(), foreignKeys);
                }
                for (Object element : temp) {
                    Object pk = this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(element, session);
                    fromCache.put(pk, element);
                }
            }
            Iterator<Object> keyIterator = keyObjects.iterator();
            for (Object key : values) {
                this.addInto(keyIterator.next(), fromCache.get(key), result, session);
            }
        }
        return result;
    }
}

