/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.util.DummyCallFlowAgentImpl;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.EntityManagerQueryMethod;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryWrapper<T extends Query>
implements Query {
    private transient CallFlowAgent callFlowAgent;
    protected T queryDelegate;
    private EntityManager entityManagerDelegate;

    public static Query createQueryWrapper(Query queryDelegate, EntityManager emDelegate) {
        return new QueryWrapper<Query>(queryDelegate, emDelegate);
    }

    protected QueryWrapper(T qDelegate, EntityManager emDelegate) {
        this.queryDelegate = qDelegate;
        this.entityManagerDelegate = emDelegate;
        this.callFlowAgent = new DummyCallFlowAgentImpl();
    }

    public List getResultList() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_RESULT_LIST);
            }
            List retVal = this.queryDelegate.getResultList();
            this.entityManagerDelegate.clear();
            List list = retVal;
            return list;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Object getSingleResult() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_SINGLE_RESULT);
            }
            Object retVal = this.queryDelegate.getSingleResult();
            this.entityManagerDelegate.clear();
            Object object = retVal;
            return object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public int executeUpdate() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.EXECUTE_UPDATE);
            this.callFlowAgent.entityManagerQueryEnd();
        }
        throw new TransactionRequiredException("executeUpdate is not supported for a Query object obtained through non-transactional access of a container-managed transactional EntityManager");
    }

    public Query setMaxResults(int maxResults) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_MAX_RESULTS);
            }
            if (maxResults < 0) {
                throw new IllegalArgumentException("maxResult cannot be negative");
            }
            this.queryDelegate.setMaxResults(maxResults);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public int getMaxResults() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_MAX_RESULTS);
            }
            int n = this.queryDelegate.getMaxResults();
            return n;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Query setFirstResult(int startPosition) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_FIRST_RESULT);
            }
            if (startPosition < 0) {
                throw new IllegalArgumentException("startPosition cannot be negative");
            }
            this.queryDelegate.setFirstResult(startPosition);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public int getFirstResult() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_FIRST_RESULT);
            }
            int n = this.queryDelegate.getFirstResult();
            return n;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Query setHint(String hintName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_HINT);
            }
            this.queryDelegate.setHint(hintName, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public Map<String, Object> getHints() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_HINTS);
            }
            Map map = this.queryDelegate.getHints();
            return map;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_PARAMETER_OBJECT);
            }
            this.queryDelegate.setParameter(param, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_PARAMETER_DATE_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(param, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_PARAMETER_CALENDAR_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(param, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public Query setParameter(String name, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_OBJECT);
            }
            this.queryDelegate.setParameter(name, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(String name, Date value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_DATE_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(name, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_STRING_CALENDAR_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(name, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public Query setParameter(int position, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_OBJECT);
            }
            this.queryDelegate.setParameter(position, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(int position, Date value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_DATE_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(position, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_PARAMETER_INT_CALENDAR_TEMPORAL_TYPE);
            }
            this.queryDelegate.setParameter(position, value, temporalType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETERS);
            }
            Set set = this.queryDelegate.getParameters();
            return set;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Parameter<?> getParameter(String name) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_NAME);
            }
            Parameter parameter = this.queryDelegate.getParameter(name);
            return parameter;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_NAME_TYPE);
            }
            Parameter parameter = this.queryDelegate.getParameter(name, type);
            return parameter;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Parameter<?> getParameter(int position) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_POSITION);
            }
            Parameter parameter = this.queryDelegate.getParameter(position);
            return parameter;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_POSITION_CLASS);
            }
            Parameter parameter = this.queryDelegate.getParameter(position, type);
            return parameter;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public boolean isBound(Parameter<?> param) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.IS_BOUND_PARAMETER);
            }
            boolean bl = this.queryDelegate.isBound(param);
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public <T> T getParameterValue(Parameter<T> param) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_VALUE_PARAMETER);
            }
            Object object = this.queryDelegate.getParameterValue(param);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Object getParameterValue(String name) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_VALUE_STRING);
            }
            Object object = this.queryDelegate.getParameterValue(name);
            return object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Object getParameterValue(int position) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_PARAMETER_VALUE_INT);
            }
            Object object = this.queryDelegate.getParameterValue(position);
            return object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Query setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_FLUSH_MODE);
            }
            this.queryDelegate.setFlushMode(flushMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public FlushModeType getFlushMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this.queryDelegate.getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Query setLockMode(LockModeType lockModeType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.SET_LOCK_MODE);
            }
            this.queryDelegate.setLockMode(lockModeType);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
        return this;
    }

    public LockModeType getLockMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.GET_LOCK_MODE);
            }
            LockModeType lockModeType = this.queryDelegate.getLockMode();
            return lockModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public <T> T unwrap(Class<T> tClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryStart(EntityManagerQueryMethod.UNWRAP);
            }
            Object object = this.queryDelegate.unwrap(tClass);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerQueryEnd();
            }
        }
    }

    public Object getSingleResultOrNull() {
        return this.queryDelegate.getSingleResult();
    }

    public Query setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        return this.queryDelegate.setCacheRetrieveMode(cacheRetrieveMode);
    }

    public Query setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        return this.queryDelegate.setCacheStoreMode(cacheStoreMode);
    }

    public CacheRetrieveMode getCacheRetrieveMode() {
        return this.queryDelegate.getCacheRetrieveMode();
    }

    public CacheStoreMode getCacheStoreMode() {
        return this.queryDelegate.getCacheStoreMode();
    }

    public Query setTimeout(Integer timeout) {
        return this.queryDelegate.setTimeout(timeout);
    }

    public Integer getTimeout() {
        return this.queryDelegate.getTimeout();
    }
}

