/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgi.cli.remote.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.glassfish.api.ActionReport;
import org.glassfish.common.util.io.EmptyInputStream;
import org.glassfish.osgi.cli.remote.impl.OsgiShellService;
import org.glassfish.osgi.cli.remote.impl.RemoteCommandSession;
import org.glassfish.osgi.cli.remote.impl.SessionOperation;

class GogoOsgiShellService
extends OsgiShellService {
    private static final Logger LOG = Logger.getLogger(GogoOsgiShellService.class.getName());
    private static final Map<String, RemoteCommandSession> SESSIONS = new ConcurrentHashMap<String, RemoteCommandSession>();
    private final CommandProcessor processor;
    private final SessionOperation sessionOperation;
    private final String sessionId;

    GogoOsgiShellService(Object service, SessionOperation sessionOperation, String sessionId, ActionReport report) {
        super(report);
        this.processor = (CommandProcessor)service;
        this.sessionOperation = sessionOperation;
        this.sessionId = sessionId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void execCommand(String cmdName, String cmd) throws Exception {
        EmptyInputStream in = new EmptyInputStream();
        if (this.sessionOperation == null) {
            if ("asadmin-osgi-shell".equals(cmdName)) {
                this.stdout.println("gogo");
                return;
            } else {
                try (CommandSession session = this.processor.createSession((InputStream)in, (OutputStream)this.stdout, (OutputStream)this.stderr);){
                    Object result = session.execute((CharSequence)cmd);
                    if (!(result instanceof String)) return;
                    this.stdout.println(result.toString());
                    return;
                }
            }
        } else if (this.sessionOperation == SessionOperation.NEW) {
            CommandSession session = this.processor.createSession((InputStream)in, (OutputStream)this.stdout, (OutputStream)this.stderr);
            RemoteCommandSession remote = new RemoteCommandSession(session);
            LOG.log(Level.FINE, "Remote session established: {0}", remote.getId());
            SESSIONS.put(remote.getId(), remote);
            this.stdout.println(remote.getId());
            return;
        } else if (this.sessionOperation == SessionOperation.LIST) {
            for (String id : SESSIONS.keySet()) {
                this.stdout.println(id);
            }
            return;
        } else if (this.sessionOperation == SessionOperation.EXECUTE) {
            RemoteCommandSession remote = SESSIONS.get(this.sessionId);
            CommandSession session = remote.attach((InputStream)in, this.stdout, this.stderr);
            Object result = session.execute((CharSequence)cmd);
            if (result instanceof String) {
                this.stdout.println(result.toString());
            }
            remote.detach();
            return;
        } else {
            if (this.sessionOperation != SessionOperation.STOP) return;
            RemoteCommandSession remote = SESSIONS.remove(this.sessionId);
            if (remote != null) {
                CommandSession session = remote.attach((InputStream)in, this.stdout, this.stderr);
                session.close();
            }
            LOG.log(Level.FINE, "Remote session closed: {0}", this.sessionId);
        }
    }
}

