/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.RIConstants;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.DebugObjectOutputStream;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Base64;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ClientSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    public static final String STATELESS = "stateless";
    private ByteArrayGuard guard;
    private boolean stateTimeoutEnabled;
    private long stateTimeout;
    private int csBuffSize;
    private boolean debugSerializedState;

    public ClientSideStateHelper() {
        this.init();
    }

    @Override
    public void writeState(FacesContext ctx, Object state, StringBuilder stateCapture) throws IOException {
        if (stateCapture != null) {
            this.doWriteState(ctx, state, new StringBuilderWriter(stateCapture));
        } else {
            ResponseWriter writer = ctx.getResponseWriter();
            writer.startElement("input", null);
            writer.writeAttribute("type", "hidden", null);
            writer.writeAttribute("name", RenderKitUtils.PredefinedPostbackParameter.VIEW_STATE_PARAM.getName(ctx), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                String viewStateId = Util.getViewStateId(ctx);
                writer.writeAttribute("id", viewStateId, null);
            }
            StringBuilder stateBuilder = new StringBuilder();
            this.doWriteState(ctx, state, new StringBuilderWriter(stateBuilder));
            writer.writeAttribute("value", stateBuilder.toString(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                writer.writeAttribute("autocomplete", "off", null);
            }
            writer.endElement("input");
            this.writeClientWindowField(ctx, writer);
            this.writeRenderKitIdField(ctx, writer);
        }
    }

    @Override
    public Object getState(FacesContext ctx, String viewId) throws IOException {
        String stateString = ClientSideStateHelper.getStateParamValue(ctx);
        if (stateString == null) {
            return null;
        }
        if (STATELESS.equals(stateString)) {
            return STATELESS;
        }
        return this.doGetState(ctx, stateString);
    }

    protected Object doGetState(FacesContext ctx, String stateString) {
        if (STATELESS.equals(stateString)) {
            return null;
        }
        ObjectInputStream ois = null;
        InputStream bis = null;
        try {
            if (this.guard != null) {
                byte[] bytes = stateString.getBytes(RIConstants.CHAR_ENCODING);
                byte[] decodedBytes = Base64.getDecoder().decode(bytes);
                bytes = this.guard.decrypt(ctx, decodedBytes);
                if (bytes == null) {
                    Object var7_11 = null;
                    return var7_11;
                }
                bis = new ByteArrayInputStream(bytes);
            }
            if (null != bis && this.compressViewState) {
                bis = new GZIPInputStream(bis);
            }
            if (null == bis) {
                throw new FacesException("Unable to encode stateString");
            }
            ois = this.serialProvider.createObjectInputStream(bis);
            long stateTime = 0L;
            if (this.stateTimeoutEnabled) {
                try {
                    stateTime = ois.readLong();
                }
                catch (IOException ioe) {
                    Object ioe2;
                    block37: {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                        }
                        ioe2 = null;
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException ioe3) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block37;
                                LOGGER.log(Level.FINEST, "Closing stream", ioe3);
                            }
                        }
                    }
                    return ioe2;
                }
            }
            Object structure = ois.readObject();
            Object state = ois.readObject();
            if (stateTime != 0L && this.hasStateExpired(stateTime)) {
                Object var9_19 = null;
                return var9_19;
            }
            Object[] objectArray = new Object[]{structure, state};
            return objectArray;
        }
        catch (OptionalDataException | ClassNotFoundException ode) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ode.getMessage(), ode);
            }
            throw new FacesException(ode);
        }
        catch (InvalidClassException ice) {
            Object var6_10 = null;
            return var6_10;
        }
        catch (IOException iox) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iox.getMessage(), iox);
            }
            throw new FacesException(iox);
        }
        finally {
            block38: {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block38;
                        LOGGER.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteState(FacesContext facesContext, Object state, Writer writer) throws IOException {
        if (facesContext.getViewRoot().isTransient()) {
            writer.write(STATELESS);
            writer.flush();
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream base = this.compressViewState ? new GZIPOutputStream((OutputStream)baos, this.csBuffSize) : baos;
        ObjectOutputStream oos = null;
        try {
            DebugObjectOutputStream out;
            ByteArrayOutputStream discard;
            oos = this.serialProvider.createObjectOutputStream(new BufferedOutputStream(base));
            if (this.stateTimeoutEnabled) {
                oos.writeLong(System.currentTimeMillis());
            }
            Object[] stateToWrite = (Object[])state;
            if (this.debugSerializedState) {
                discard = new ByteArrayOutputStream();
                out = new DebugObjectOutputStream(discard);
                try {
                    out.writeObject(stateToWrite[0]);
                }
                catch (Exception e) {
                    throw new FacesException("Serialization error. Path to offending instance: " + out.getStack(), e);
                }
            }
            oos.writeObject(stateToWrite[0]);
            if (this.debugSerializedState) {
                discard = new ByteArrayOutputStream();
                out = new DebugObjectOutputStream(discard);
                try {
                    out.writeObject(stateToWrite[1]);
                }
                catch (Exception e) {
                    DebugUtil.printState((Map)stateToWrite[1], LOGGER);
                    throw new FacesException("Serialization error. Path to offending instance: " + out.getStack(), e);
                }
            }
            oos.writeObject(stateToWrite[1]);
            oos.flush();
            oos.close();
            oos = null;
            byte[] bytes = baos.toByteArray();
            if (this.guard != null) {
                bytes = this.guard.encrypt(facesContext, bytes);
            }
            String encodedBytes = new String(Base64.getEncoder().encode(bytes));
            writer.write(encodedBytes);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client State: total number of characters written: {0}", encodedBytes.length());
            }
        }
        finally {
            block19: {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException ioe) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                        LOGGER.log(Level.FINEST, "Closing stream", ioe);
                    }
                }
            }
        }
    }

    protected boolean hasStateExpired(long stateTime) {
        if (this.stateTimeoutEnabled) {
            long elapsed = (System.currentTimeMillis() - stateTime) / 60000L;
            return elapsed > this.stateTimeout;
        }
        return false;
    }

    protected void init() {
        if (this.webConfig.canProcessJndiEntries() && !this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.DisableClientStateEncryption)) {
            this.guard = new ByteArrayGuard();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "faces.config.webconfig.enventry.clientencrypt");
        }
        this.stateTimeoutEnabled = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
        if (this.stateTimeoutEnabled) {
            String timeout = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
            try {
                this.stateTimeout = Long.parseLong(timeout);
                if (this.stateTimeout < 0L) {
                    this.stateTimeoutEnabled = false;
                }
            }
            catch (NumberFormatException nfe) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, WebConfiguration.WebContextInitParameter.ClientStateTimeout.getQualifiedName() + " context param value of '" + timeout + "' is not parseable as Long, it will be ignored");
                }
                this.stateTimeoutEnabled = false;
            }
        }
        String size = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String defaultSize = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(size);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "faces.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
                }
                this.csBuffSize = Integer.parseInt(defaultSize);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "faces.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), size, defaultSize});
            }
            this.csBuffSize = Integer.parseInt(defaultSize);
        }
        this.debugSerializedState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableClientStateDebugging);
    }

    @Override
    public boolean isStateless(FacesContext facesContext, String viewId) throws IllegalStateException {
        if (facesContext.isPostback()) {
            Object stateObject;
            try {
                stateObject = this.getState(facesContext, viewId);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Cannot determine whether or not the request is stateless", ioe);
            }
            return STATELESS.equals(stateObject);
        }
        throw new IllegalStateException("Cannot determine whether or not the request is stateless");
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private final StringBuilder sb;

        protected StringBuilderWriter(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void write(int c) throws IOException {
            this.sb.append((char)c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.sb.append(cbuf);
        }

        @Override
        public void write(String str) throws IOException {
            this.sb.append(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.sb.append(str.toCharArray(), off, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.sb.append(csq);
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.sb.append(csq, start, end);
            return this;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.sb.append(c);
            return this;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

