/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.binaryclass;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import org.glassfish.rmic.tools.binaryclass.BinaryAttribute;
import org.glassfish.rmic.tools.binaryclass.BinaryConstantPool;
import org.glassfish.rmic.tools.binaryclass.BinaryMember;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Constants;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.MemberDefinition;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.javac.BatchEnvironment;
import org.glassfish.rmic.tools.javac.Main;

public final class BinaryClass
extends ClassDefinition
implements Constants {
    BinaryConstantPool cpool;
    BinaryAttribute atts;
    Vector<ClassDeclaration> dependencies;
    private boolean haveLoadedNested = false;
    private boolean basicCheckDone = false;
    private boolean basicChecking = false;

    private BinaryClass(Object source, ClassDeclaration declaration, int modifiers, ClassDeclaration superClass, ClassDeclaration[] interfaces, Vector<ClassDeclaration> dependencies) {
        super(source, 0L, declaration, modifiers, null, null);
        this.dependencies = dependencies;
        this.superClass = superClass;
        this.interfaces = interfaces;
    }

    @Override
    protected void basicCheck(Environment env) throws ClassNotFound {
        env.dtEnter("BinaryClass.basicCheck: " + this.getName());
        if (this.basicChecking || this.basicCheckDone) {
            env.dtExit("BinaryClass.basicCheck: OK " + this.getName());
            return;
        }
        env.dtEvent("BinaryClass.basicCheck: CHECKING " + this.getName());
        this.basicChecking = true;
        super.basicCheck(env);
        if (doInheritanceChecks) {
            this.collectInheritedMethods(env);
        }
        this.basicCheckDone = true;
        this.basicChecking = false;
        env.dtExit("BinaryClass.basicCheck: " + this.getName());
    }

    public static BinaryClass load(Environment env, DataInputStream in, int mask) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("wrong magic: " + magic + ", expected -889275714");
        }
        int minor_version = in.readUnsignedShort();
        int version = in.readUnsignedShort();
        if (version < 45) {
            throw new ClassFormatError(Main.getText("javac.err.version.too.old", String.valueOf(version)));
        }
        if (version > BinaryClass.getMaxSupportedClassVersion() || version == BinaryClass.getMaxSupportedClassVersion() && minor_version > 0) {
            throw new ClassFormatError(Main.getText("javac.err.version.too.recent", version + "." + minor_version, BinaryClass.getMaxSupportedClassVersion() + ".0"));
        }
        BinaryConstantPool cpool = new BinaryConstantPool(in);
        Vector<ClassDeclaration> dependencies = cpool.getDependencies(env);
        int classMod = in.readUnsignedShort() & 0xE31;
        ClassDeclaration classDecl = cpool.getDeclaration(env, in.readUnsignedShort());
        ClassDeclaration superClassDecl = cpool.getDeclaration(env, in.readUnsignedShort());
        ClassDeclaration[] interfaces = new ClassDeclaration[in.readUnsignedShort()];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaces[i] = cpool.getDeclaration(env, in.readUnsignedShort());
        }
        BinaryClass c = new BinaryClass(null, classDecl, classMod, superClassDecl, interfaces, dependencies);
        c.cpool = cpool;
        c.addDependency(superClassDecl);
        int nfields = in.readUnsignedShort();
        for (int i = 0; i < nfields; ++i) {
            int fieldMod = in.readUnsignedShort() & 0xDF;
            Identifier fieldName = cpool.getIdentifier(in.readUnsignedShort());
            Type fieldType = cpool.getType(in.readUnsignedShort());
            BinaryAttribute atts = BinaryAttribute.load(in, cpool, mask);
            c.addMember(new BinaryMember(c, fieldMod, fieldType, fieldName, atts));
        }
        int nmethods = in.readUnsignedShort();
        for (int i = 0; i < nmethods; ++i) {
            int methMod = in.readUnsignedShort() & 0xD3F;
            Identifier methName = cpool.getIdentifier(in.readUnsignedShort());
            Type methType = cpool.getType(in.readUnsignedShort());
            BinaryAttribute atts = BinaryAttribute.load(in, cpool, mask);
            c.addMember(new BinaryMember(c, methMod, methType, methName, atts));
        }
        c.atts = BinaryAttribute.load(in, cpool, mask);
        byte[] data = c.getAttribute(idSourceFile);
        if (data != null) {
            DataInputStream dataStream = new DataInputStream(new ByteArrayInputStream(data));
            c.source = cpool.getString(dataStream.readUnsignedShort());
        }
        if ((data = c.getAttribute(idDocumentation)) != null) {
            c.documentation = new DataInputStream(new ByteArrayInputStream(data)).readUTF();
        }
        if (c.getAttribute(idDeprecated) != null) {
            c.modifiers |= 0x40000;
        }
        if (c.getAttribute(idSynthetic) != null) {
            c.modifiers |= 0x80000;
        }
        return c;
    }

    private static int getMaxSupportedClassVersion() {
        return BatchEnvironment.getMaxSupportedClassVersion();
    }

    @Override
    public void loadNested(Environment env) {
        this.loadNested(env, 0);
    }

    private void loadNested(Environment env, int flags) {
        if (this.haveLoadedNested) {
            env.dtEvent("loadNested: DUPLICATE CALL SKIPPED");
            return;
        }
        this.haveLoadedNested = true;
        try {
            byte[] data = this.getAttribute(idInnerClasses);
            if (data != null) {
                this.initInnerClasses(env, data, flags);
            }
        }
        catch (IOException ee) {
            env.error(0L, "malformed.attribute", this.getClassDeclaration(), idInnerClasses);
            env.dtEvent("loadNested: MALFORMED ATTRIBUTE (InnerClasses)");
        }
    }

    private void initInnerClasses(Environment env, byte[] data, int flags) throws IOException {
        DataInputStream ds = new DataInputStream(new ByteArrayInputStream(data));
        int nrec = ds.readUnsignedShort();
        for (int i = 0; i < nrec; ++i) {
            boolean accessible;
            int inner_index = ds.readUnsignedShort();
            ClassDeclaration inner = this.cpool.getDeclaration(env, inner_index);
            ClassDeclaration outer = null;
            int outer_index = ds.readUnsignedShort();
            if (outer_index != 0) {
                outer = this.cpool.getDeclaration(env, outer_index);
            }
            Identifier inner_nm = idNull;
            int inner_nm_index = ds.readUnsignedShort();
            if (inner_nm_index != 0) {
                inner_nm = Identifier.lookup(this.cpool.getString(inner_nm_index));
            }
            int mods = ds.readUnsignedShort();
            boolean bl = accessible = outer != null && !inner_nm.equals(idNull) && ((mods & 2) == 0 || (flags & 4) != 0);
            if (!accessible) continue;
            Identifier nm = Identifier.lookupInner(outer.getName(), inner_nm);
            Type.tClass(nm);
            if (inner.equals(this.getClassDeclaration())) {
                try {
                    ClassDefinition outerClass = outer.getClassDefinition(env);
                    this.initInner(outerClass, mods);
                }
                catch (ClassNotFound outerClass) {}
                continue;
            }
            if (!outer.equals(this.getClassDeclaration())) continue;
            try {
                ClassDefinition innerClass = inner.getClassDefinition(env);
                this.initOuter(innerClass, mods);
                continue;
            }
            catch (ClassNotFound classNotFound) {
                // empty catch block
            }
        }
    }

    private void initInner(ClassDefinition outerClass, int mods) {
        if (this.getOuterClass() != null) {
            return;
        }
        if ((mods & 2) != 0) {
            mods &= 0xFFFFFFFA;
        } else if ((mods & 4) != 0) {
            mods &= 0xFFFFFFFE;
        }
        if ((mods & 0x200) != 0) {
            mods |= 0x408;
        }
        if (outerClass.isInterface()) {
            mods |= 9;
            mods &= 0xFFFFFFF9;
        }
        this.modifiers = mods;
        this.setOuterClass(outerClass);
        for (MemberDefinition field = this.getFirstMember(); field != null; field = field.getNextMember()) {
            if (!field.isUplevelValue() || !outerClass.getType().equals(field.getType()) || !field.getName().toString().startsWith("this$")) continue;
            this.setOuterMember(field);
        }
    }

    private void initOuter(ClassDefinition innerClass, int mods) {
        if (innerClass instanceof BinaryClass) {
            ((BinaryClass)innerClass).initInner(this, mods);
        }
        this.addMember(new BinaryMember(innerClass));
    }

    public void write(Environment env, OutputStream out) throws IOException {
        String signature;
        String name;
        MemberDefinition f;
        DataOutputStream data = new DataOutputStream(out);
        data.writeInt(-889275714);
        data.writeShort(env.getMinorVersion());
        data.writeShort(env.getMajorVersion());
        this.cpool.write(data, env);
        data.writeShort(this.getModifiers() & 0xE31);
        data.writeShort(this.cpool.indexObject(this.getClassDeclaration(), env));
        data.writeShort(this.getSuperClass() != null ? this.cpool.indexObject(this.getSuperClass(), env) : 0);
        data.writeShort(this.interfaces.length);
        for (int i = 0; i < this.interfaces.length; ++i) {
            data.writeShort(this.cpool.indexObject(this.interfaces[i], env));
        }
        int fieldCount = 0;
        int methodCount = 0;
        for (f = this.firstMember; f != null; f = f.getNextMember()) {
            if (f.isMethod()) {
                ++methodCount;
                continue;
            }
            ++fieldCount;
        }
        data.writeShort(fieldCount);
        for (f = this.firstMember; f != null; f = f.getNextMember()) {
            if (f.isMethod()) continue;
            data.writeShort(f.getModifiers() & 0xDF);
            name = f.getName().toString();
            signature = f.getType().getTypeSignature();
            data.writeShort(this.cpool.indexString(name, env));
            data.writeShort(this.cpool.indexString(signature, env));
            BinaryAttribute.write(((BinaryMember)f).atts, data, this.cpool, env);
        }
        data.writeShort(methodCount);
        for (f = this.firstMember; f != null; f = f.getNextMember()) {
            if (!f.isMethod()) continue;
            data.writeShort(f.getModifiers() & 0xD3F);
            name = f.getName().toString();
            signature = f.getType().getTypeSignature();
            data.writeShort(this.cpool.indexString(name, env));
            data.writeShort(this.cpool.indexString(signature, env));
            BinaryAttribute.write(((BinaryMember)f).atts, data, this.cpool, env);
        }
        BinaryAttribute.write(this.atts, data, this.cpool, env);
        data.flush();
    }

    @Override
    public Iterator<ClassDeclaration> getDependencies() {
        return this.dependencies.iterator();
    }

    @Override
    public void addDependency(ClassDeclaration c) {
        if (c != null && !this.dependencies.contains(c)) {
            this.dependencies.addElement(c);
        }
    }

    public BinaryConstantPool getConstants() {
        return this.cpool;
    }

    public byte[] getAttribute(Identifier name) {
        BinaryAttribute att = this.atts;
        while (att != null) {
            if (att.name.equals(name)) {
                return att.data;
            }
            att = att.next;
        }
        return null;
    }
}

