/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.commons;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.Component;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTaskManager {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private volatile ScheduledExecutorService executorService;
    private boolean useContainerSpi = true;

    protected abstract Component getComponent();

    protected abstract String getThreadPoolName();

    protected abstract ThreadFactory createThreadFactory();

    protected abstract int getThreadPoolSize();

    protected abstract Logger getLogger();

    protected AbstractTaskManager() {
    }

    protected void close(boolean force, long delayMillis) {
        if (this.useContainerSpi) {
            return;
        }
        if (this.executorService == null) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            this.executorService.shutdown();
        }
        if (!force) {
            return;
        }
        if (!this.executorService.isTerminated()) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException ex) {
                this.getLogger().fine("Interrupted while waiting for a scheduler to shut down.", (Throwable)ex);
            }
            if (!this.executorService.isTerminated()) {
                this.executorService.shutdownNow();
            }
        }
    }

    public void close() {
        this.close(false, 0L);
    }

    public boolean isClosed() {
        if (this.useContainerSpi) {
            return false;
        }
        return this.isClosed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScheduledExecutorService getExecutorService() {
        if (this.executorService == null) {
            AbstractTaskManager abstractTaskManager = this;
            synchronized (abstractTaskManager) {
                if (this.executorService == null) {
                    if (this.getComponent() != null) {
                        this.executorService = this.getComponent().getSPI(ScheduledExecutorService.class);
                    }
                    if (this.executorService == null) {
                        this.getLogger().finer("Container did not return SPI for ScheduledExecutorService - creating thread pool for " + this.getThreadPoolName());
                        ThreadFactory threadFactory = this.createThreadFactory();
                        this.executorService = threadFactory == null ? Executors.newScheduledThreadPool(this.getThreadPoolSize()) : Executors.newScheduledThreadPool(this.getThreadPoolSize(), threadFactory);
                        this.useContainerSpi = false;
                    } else {
                        this.getLogger().finer("Using Container SPI for ScheduledExecutorService for " + this.getThreadPoolName());
                        this.useContainerSpi = true;
                    }
                    this.isClosed.set(false);
                }
            }
        }
        return this.executorService;
    }
}

