/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import org.glassfish.appclient.client.acc.agent.ClassLoaderWrapper;
import org.glassfish.appclient.common.ClassPathUtils;

public class ACCAgentClassLoader
extends URLClassLoader {
    private boolean isActive = true;

    public ACCAgentClassLoader(ClassLoader parent) {
        super("Agent", new URL[0], ACCAgentClassLoader.prepareLoader(parent));
    }

    private static URLClassLoader prepareLoader(ClassLoader parent) {
        return new URLClassLoader("User", new URL[]{ClassPathUtils.getGFClientJarURL()}, new ClassLoaderWrapper(parent));
    }

    public ACCAgentClassLoader(URL[] urls) {
        super(urls);
    }

    public ACCAgentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)new ClassLoaderWrapper(parent));
    }

    public ACCAgentClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public void appendToClassPathForInstrumentation(String path) throws MalformedURLException {
        this.addURL(new File(path).toURI().toURL());
    }

    @Override
    public synchronized Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isActive && this.isStillActive()) {
            return super.loadClass(name);
        }
        return this.getParent().loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.isActive && this.isStillActive()) {
            return super.getResource(name);
        }
        return this.getParent().getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isActive && this.isStillActive()) {
            return super.getResources(name);
        }
        return this.getParent().getResources(name);
    }

    private boolean isStillActive() {
        if (this.isActive) {
            String propValue = System.getProperty("org.glassfish.appclient.acc.agentLoaderDone");
            this.isActive = propValue != null;
        }
        return this.isActive;
    }

    static {
        ACCAgentClassLoader.registerAsParallelCapable();
    }
}

