/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.AnnotationMemberImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.util.reflection.Reflections;

class AnnotationInfoImpl
implements AnnotationInfo {
    final Annotation annotation;
    final BeanManager bm;

    AnnotationInfoImpl(Annotation annotation, BeanManager bm) {
        this.annotation = annotation;
        this.bm = bm;
    }

    @Override
    public ClassInfo declaration() {
        return new ClassInfoImpl(this.bm.createAnnotatedType(this.annotation.annotationType()), this.bm);
    }

    @Override
    public boolean hasMember(String name) {
        try {
            this.annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public AnnotationMember member(String name) {
        try {
            Method member = this.annotation.annotationType().getDeclaredMethod(name, new Class[0]);
            Reflections.ensureAccessible(member, this.annotation);
            Object value = member.invoke((Object)this.annotation, new Object[0]);
            return new AnnotationMemberImpl(value, this.bm);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw LiteExtensionTranslatorLogger.LOG.unableToAccessAnnotationMembers(this.annotation, e.toString(), e);
        }
    }

    @Override
    public Map<String, AnnotationMember> members() {
        try {
            Method[] members = this.annotation.annotationType().getDeclaredMethods();
            HashMap<String, AnnotationMember> result = new HashMap<String, AnnotationMember>();
            for (Method member : members) {
                Reflections.ensureAccessible(member, this.annotation);
                String name = member.getName();
                Object value = member.invoke((Object)this.annotation, new Object[0]);
                result.put(name, new AnnotationMemberImpl(value, this.bm));
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw LiteExtensionTranslatorLogger.LOG.unableToAccessAnnotationMembers(this.annotation, e.toString(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationInfoImpl that = (AnnotationInfoImpl)o;
        return Objects.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        return Objects.hash(this.annotation);
    }

    public String toString() {
        return this.annotation.toString();
    }
}

