/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.IllegalBatchPropertyException;
import com.ibm.jbatch.jsl.model.Property;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DependencyInjectionUtility {
    private static final String sourceClass = DependencyInjectionUtility.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    public static void injectReferences(Object artifact, InjectionReferences injectionRefs) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Injecting references into: " + artifact);
            logger.fine("InjectionReferences = " + injectionRefs);
        }
        Map<String, Field> propertyMap = DependencyInjectionUtility.findPropertyFields(artifact);
        if (injectionRefs.getProps() != null) {
            DependencyInjectionUtility.injectProperties(artifact, injectionRefs.getProps(), propertyMap);
        }
        DependencyInjectionUtility.injectBatchContextFields(artifact, injectionRefs.getJobContext(), injectionRefs.getStepContext());
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, "injectReferences");
        }
    }

    private static void injectProperties(Object artifact, List<Property> props, Map<String, Field> propertyFieldMap) {
        if (props == null || propertyFieldMap == null) {
            return;
        }
        for (Map.Entry<String, Field> batchProperty : propertyFieldMap.entrySet()) {
            String propValue = DependencyInjectionUtility.getPropertyValue(props, batchProperty.getKey());
            try {
                if (propValue == null) continue;
                batchProperty.getValue().set(artifact, propValue);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalBatchPropertyException("The given property value is not an instance of the declared field.", e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    public static String getPropertyValue(List<Property> props, String name) {
        if (props == null) {
            return null;
        }
        for (Property prop : props) {
            if (!name.equals(prop.getName())) continue;
            String propValue = prop.getValue();
            if ("".equals(propValue)) {
                return null;
            }
            return propValue;
        }
        return null;
    }

    private static void injectBatchContextFields(Object artifact, JobContext jobCtx, StepContext stepCtx) {
        for (final Field field : artifact.getClass().getDeclaredFields()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Found Context on (Object, field)", new Object[]{artifact, field.getName()});
            }
            try {
                if (JobContext.class.isAssignableFrom(field.getType())) {
                    field.set(artifact, jobCtx);
                    continue;
                }
                if (!StepContext.class.isAssignableFrom(field.getType())) continue;
                field.set(artifact, stepCtx);
            }
            catch (IllegalArgumentException e) {
                throw new BatchContainerRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
    }

    private static Map<String, Field> findPropertyFields(Object delegate) {
        HashMap<String, Field> propertyMap = null;
        for (final Field field : delegate.getClass().getDeclaredFields()) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            BatchProperty batchPropertyAnnotation = field.getAnnotation(BatchProperty.class);
            if (batchPropertyAnnotation == null) continue;
            if (propertyMap == null) {
                propertyMap = new HashMap<String, Field>();
            }
            String batchPropName = null;
            batchPropName = batchPropertyAnnotation.name().equals("") ? field.getName() : batchPropertyAnnotation.name();
            if (propertyMap.containsKey(batchPropName)) {
                throw new IllegalBatchPropertyException("There is already a batch property with this name: " + batchPropName);
            }
            propertyMap.put(batchPropName, field);
        }
        return propertyMap;
    }
}

