/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.spi.services.IBatchConfig;
import jakarta.batch.runtime.BatchStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobStatusManagerImpl
implements IJobStatusManagerService {
    private static final String CLASSNAME = JobStatusManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(JobStatusManagerImpl.class.getPackage().getName());
    private IPersistenceManagerService _persistenceManager;

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        JobStatus jobStatus = null;
        jobStatus = this._persistenceManager.createJobStatus(jobInstanceId);
        return jobStatus;
    }

    @Override
    public JobStatus getJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        JobStatus jobStatus = null;
        jobStatus = this._persistenceManager.getJobStatus(jobInstanceId);
        return jobStatus;
    }

    @Override
    public void updateJobStatus(JobStatus jobStatus) {
        this.persistJobStatus(jobStatus.getJobInstanceId(), jobStatus);
    }

    @Override
    public JobStatus getJobStatusFromExecutionId(long executionId) throws BatchContainerServiceException {
        JobStatus retVal = null;
        logger.fine("For executionId: " + executionId);
        try {
            retVal = this._persistenceManager.getJobStatusFromExecution(executionId);
        }
        catch (PersistenceException e) {
            logger.warning("Did not find job instance status for executionId: " + executionId);
            throw e;
        }
        logger.fine("Returning : " + retVal);
        return retVal;
    }

    @Override
    public void updateJobBatchStatus(long jobInstanceId, BatchStatus batchStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        if (BatchStatus.ABANDONED.equals((Object)js.getBatchStatus())) {
            logger.fine("Don't update batch status for id = " + jobInstanceId + " since it is already ABANDONED");
        }
        js.setBatchStatus(batchStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobExecutionStatus(long jobInstanceId, BatchStatus batchStatus, String exitStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        js.setExitStatus(exitStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobCurrentStep(long jobInstanceId, String currentStepName) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setCurrentStepId(currentStepName);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobStatusWithNewExecution(long jobInstanceId, long newExecutionId) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(null);
        js.setLatestExecutionId(newExecutionId);
        js.setBatchStatus(BatchStatus.STARTING);
        this.persistJobStatus(jobInstanceId, js);
    }

    private void persistJobStatus(long jobInstanceId, JobStatus newJobStatus) throws BatchContainerServiceException {
        this._persistenceManager.updateJobStatus(jobInstanceId, newJobStatus);
    }

    @Override
    public StepStatus createStepStatus(long stepExecutionId) throws BatchContainerServiceException {
        return this._persistenceManager.createStepStatus(stepExecutionId);
    }

    @Override
    public StepStatus getStepStatus(long jobInstanceId, String stepId) throws BatchContainerServiceException {
        String method = "getStepStatus";
        logger.entering(CLASSNAME, method, new Object[]{jobInstanceId, stepId});
        StepStatus stepStatus = this._persistenceManager.getStepStatus(jobInstanceId, stepId);
        logger.exiting(CLASSNAME, method, stepStatus == null ? "<null>" : stepStatus);
        return stepStatus;
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus newStepStatus) {
        String method = "updateStepStatus";
        logger.entering(CLASSNAME, method, new Object[]{stepExecutionId, newStepStatus});
        this._persistenceManager.updateStepStatus(stepExecutionId, newStepStatus);
        logger.exiting(CLASSNAME, method);
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, method);
        }
        ServicesManager sm = ServicesManagerImpl.getInstance();
        this._persistenceManager = sm.getPersistenceManagerService();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, method);
        }
    }

    @Override
    public void updateJobStatusFromJSLStop(long jobInstanceId, String restartOn) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(restartOn);
        this.persistJobStatus(jobInstanceId, js);
    }
}

