/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.ButtonBarBuilder;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.TableControl;
import org.eclipse.emfforms.spi.swt.table.TableViewerComparator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractTableViewerComposite<V extends AbstractTableViewer>
extends Composite {
    private final EMFDataBindingContext emfDatabindingContext = new EMFDataBindingContext();
    private Optional<List<Control>> validationControls;
    private final Set<Feature> enabledFeatures;

    protected AbstractTableViewerComposite(Composite parent, int style, Object inputObject, TableViewerSWTCustomization<V> customization, IObservableValue<Object> title, IObservableValue<Object> tooltip) {
        super(parent, style);
        this.enabledFeatures = this.determineEnabledFeatures(customization);
        this.renderControl(this, customization, inputObject, this.emfDatabindingContext, title, tooltip);
    }

    private Set<Feature> determineEnabledFeatures(TableViewerSWTCustomization<V> customization) {
        LinkedHashSet<Feature> enabled = new LinkedHashSet<Feature>();
        enabled.addAll(customization.getTableConfiguration().getEnabledFeatures());
        for (ColumnConfiguration columnConfig : customization.getColumnConfigurations()) {
            enabled.addAll(columnConfig.getEnabledFeatures());
        }
        return enabled;
    }

    public Set<Feature> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public abstract V getTableViewer();

    public Optional<List<Control>> getValidationControls() {
        return this.validationControls;
    }

    protected void configureContextMenu(V tableViewer) {
    }

    protected void configureViewerFilters(V tableViewer) {
    }

    private void renderControl(Composite parent, TableViewerSWTCustomization<V> customization, Object inputObject, EMFDataBindingContext emfDataBindingContext, IObservableValue<Object> title, IObservableValue<Object> tooltip) {
        customization.createCompositeLayout(parent);
        Optional<Label> titleLabel = customization.getTitleLabel();
        if (titleLabel.isPresent()) {
            AbstractTableViewerComposite.initTitleLabel((Label)titleLabel.get(), title, tooltip, this.emfDatabindingContext);
        }
        this.validationControls = customization.getValidationControls();
        Composite viewerComposite = customization.getViewerComposite();
        V tableViewer = this.createTableViewer(customization, viewerComposite);
        Optional<Composite> buttonComposite = customization.getButtonComposite();
        if (buttonComposite.isPresent()) {
            AbstractTableViewerComposite.initButtonComposite((Composite)buttonComposite.get(), customization, tableViewer);
        }
        AbstractTableViewerComposite.enableTooltipSupport(tableViewer);
        Optional<ViewerComparator> comparator = customization.getComparator();
        if (comparator.isPresent()) {
            tableViewer.setComparator((ViewerComparator)comparator.get());
        }
        tableViewer.setContentProvider(customization.createContentProvider());
        this.addColumns(customization, tableViewer, emfDataBindingContext);
        this.setupDragAndDrop(customization, tableViewer);
        this.configureContextMenu(tableViewer);
        this.configureViewerFilters(tableViewer);
        tableViewer.setInput(inputObject);
        AbstractColumnLayout layout = this.createLayout(viewerComposite);
        Widget[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            Widget tableColumn = columns[i];
            boolean storedIsResizable = (Boolean)tableColumn.getData("resizable");
            Integer storedWeight = (Integer)tableColumn.getData("weight");
            Integer storedMinWidth = (Integer)tableColumn.getData("min_width");
            if (storedWeight == -1) {
                layout.setColumnData(tableColumn, (ColumnLayoutData)new ColumnPixelData(storedMinWidth.intValue(), storedIsResizable));
            } else if (storedMinWidth > 0) {
                layout.setColumnData(tableColumn, (ColumnLayoutData)new ColumnWeightData(storedWeight.intValue(), storedMinWidth.intValue(), storedIsResizable));
            } else {
                layout.setColumnData(tableColumn, (ColumnLayoutData)new ColumnWeightData(storedWeight.intValue(), storedIsResizable));
            }
            ++i;
        }
    }

    private void setupDragAndDrop(TableViewerSWTCustomization<V> customization, V tableViewer) {
        if (customization.hasDND()) {
            tableViewer.addDragSupport(customization.getDragOperations(), customization.getDragTransferTypes(), customization.getDragListener((AbstractTableViewer)tableViewer));
            tableViewer.addDropSupport(customization.getDropOperations(), customization.getDropTransferTypes(), customization.getDropListener((AbstractTableViewer)tableViewer));
        }
    }

    public abstract Widget[] getColumns();

    protected abstract AbstractColumnLayout createLayout(Composite var1);

    protected abstract V createTableViewer(TableViewerSWTCustomization<V> var1, Composite var2);

    private void addColumns(TableViewerSWTCustomization<V> customization, V tableViewer, EMFDataBindingContext emfDataBindingContext) {
        for (ColumnConfiguration columnConfiguration : customization.getColumnConfigurations()) {
            this.createColumn(columnConfiguration, emfDataBindingContext, tableViewer);
        }
    }

    protected abstract ViewerColumn createColumn(ColumnConfiguration var1, EMFDataBindingContext var2, V var3);

    public ColumnConfiguration getColumnConfiguration(Widget columnWidget) {
        return (ColumnConfiguration)columnWidget.getData("emfforms.column.configuration");
    }

    protected static ColumnViewerEditorActivationStrategy createColumnViewerActivationStrategy(AbstractTableViewer tableViewer) {
        return new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
    }

    private static void enableTooltipSupport(AbstractTableViewer tableViewer) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
    }

    private static void initButtonComposite(Composite composite, ButtonBarBuilder customization, AbstractTableViewer viewer) {
        customization.fillButtonComposite(composite, viewer);
    }

    private static void initTitleLabel(Label label, IObservableValue<Object> title, IObservableValue<Object> tooltip, EMFDataBindingContext emfDatabindingContext) {
        emfDatabindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)label), title);
        emfDatabindingContext.bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)label), tooltip);
    }

    public void dispose() {
        this.emfDatabindingContext.dispose();
        super.dispose();
    }

    public abstract void addColumnListener(ControlListener var1);

    public abstract TableControl getTableControl();

    public abstract void setComparator(TableViewerComparator var1, List<Integer> var2);
}

