/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.test.unit.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.internal.favorites.IPersistenceUtil;
import org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesContributedAction;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.persistence.DestinationItemPair;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.env.IErrorHandler;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.ui.WorkbenchException;
import org.jmock.core.Constraint;

public class SaveInFavoritesContributedActionTest
extends MockObjectTestCase {
    private SaveInFavoritesContributedAction action;
    private Mock<ILongOperationRunner> operationRunner;
    private Set<Object> selectedObjects;
    private Mock<IPersistenceUtil> persistenceUtil;
    private Mock<ISearchParameters> searchParams;
    private Mock<IErrorHandler> errorHandler;
    private Mock<ISearchContext> searchContext;
    private Mock<ISearchDestination> searchDestination;

    protected void setUp() throws Exception {
        this.operationRunner = this.mock(ILongOperationRunner.class);
        this.selectedObjects = new HashSet<Object>();
        this.persistenceUtil = this.mock(IPersistenceUtil.class);
        this.searchParams = this.mock(ISearchParameters.class);
        this.searchContext = this.mock(ISearchContext.class);
        this.searchDestination = this.mock(ISearchDestination.class);
        this.searchContext.stubs().method("searchParameters").will(this.returnValue(this.searchParams.proxy()));
        this.searchParams.stubs().method("getSearchDestination").will(this.returnValue(this.searchDestination.proxy()));
        this.errorHandler = this.mock(IErrorHandler.class);
        this.action = new SaveInFavoritesContributedAction(){

            protected IPersistenceUtil createPersistenceUtil() {
                return (IPersistenceUtil)SaveInFavoritesContributedActionTest.this.persistenceUtil.proxy();
            }
        };
    }

    public void testExectuteActionWithNoSearchContext() {
        try {
            this.action.perform((ILongOperationRunner)this.operationRunner.proxy(), this.selectedObjects);
            SaveInFavoritesContributedActionTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testExectuteActionWithNoErrorHandler() {
        this.action.setSearchContext((ISearchContext)this.searchContext.proxy());
        try {
            this.action.perform((ILongOperationRunner)this.operationRunner.proxy(), this.selectedObjects);
            SaveInFavoritesContributedActionTest.fail((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testPerformAction() {
        this.selectedObjects.add("Test object");
        this.persistenceUtil.expects(this.once()).method("addItems").with((Constraint)this.eq(this.toPairs(this.selectedObjects)), (Constraint)this.eq(this.operationRunner.proxy()));
        this.prepareAction();
        this.action.perform((ILongOperationRunner)this.operationRunner.proxy(), this.selectedObjects);
    }

    public void testPerformActionWithWbException() {
        this.performActionWithExceptionTest((Exception)new WorkbenchException("test"));
    }

    public void testPerformActionWithIOException() {
        this.performActionWithExceptionTest(new IOException());
    }

    public void testPerformActionWithMementoException() {
        this.performActionWithExceptionTest((Exception)new MementoContentManagerException());
    }

    public void testGetActionId() {
        SaveInFavoritesContributedActionTest.assertEquals((String)"Unexpected action id", (Object)"org.eclipse.platform.discovery.integration.internal.viewcustomization.SaveInFavoritesContributedAction", (Object)this.action.getActionId());
    }

    private void performActionWithExceptionTest(Exception exc) {
        this.selectedObjects.add("Test object");
        this.persistenceUtil.expects(this.once()).method("addItems").with((Constraint)this.eq(this.toPairs(this.selectedObjects)), (Constraint)this.eq(this.operationRunner.proxy())).will(this.throwException(exc));
        this.errorHandler.expects(this.once()).method("handleException").with((Constraint)this.eq(exc));
        this.prepareAction();
        this.action.perform((ILongOperationRunner)this.operationRunner.proxy(), this.selectedObjects);
    }

    private void prepareAction() {
        this.action.setSearchContext((ISearchContext)this.searchContext.proxy());
        this.action.setErrorHandler((IErrorHandler)this.errorHandler.proxy());
    }

    private Set<DestinationItemPair> toPairs(Set<Object> objects) {
        HashSet<DestinationItemPair> result = new HashSet<DestinationItemPair>();
        for (Object o : objects) {
            result.add(new DestinationItemPair((ISearchDestination)this.searchDestination.proxy(), o));
        }
        return result;
    }
}

