/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.util.List;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalObject;

public class LocalFolder
extends LocalObject {
    public LocalFolder(FileSystemRepository repository) {
        super(repository);
    }

    public void deleteTree() throws LocalBaseException {
        this.getRepository().getRepositoryDAO().removeFolderByPath(this.getPath());
    }

    public List<LocalObject> getChildren() throws LocalBaseException {
        List<LocalObject> result = this.getRepository().getRepositoryDAO().getChildrenByFolder(this.getPath());
        return result;
    }

    public void createFolder(String name) throws LocalBaseException {
        this.getRepository().getRepositoryDAO().createFolder(RepositoryPath.normalizePath((String)this.getPath(), (String)name));
    }

    public void createFile(String name, byte[] content, boolean isBinary, String contentType) throws LocalBaseException {
        this.getRepository().getRepositoryDAO().createFile(RepositoryPath.normalizePath((String)this.getPath(), (String)name), content, isBinary, contentType);
    }

    public void renameFolder(String newPath) throws LocalBaseException {
        this.getRepository().getRepositoryDAO().renameFolder(this.getPath(), newPath);
    }
}

