/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.dirigible.repository.datasource.DataSourcesActivator;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.logging.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

class DialectFactoryOSGi {
    private static final Logger logger = Logger.getLogger((String)DialectFactoryOSGi.class.getCanonicalName());
    static Collection<IDialectSpecifier> dialectSpecifiers = new ArrayList<IDialectSpecifier>();
    static boolean registered = false;

    DialectFactoryOSGi() {
    }

    public static <T> Collection<T> getServices(Class<T> clazz) {
        if (DataSourcesActivator.getContext() == null) {
            return null;
        }
        ArrayList<Object> services = null;
        try {
            Collection serviceReferences = DataSourcesActivator.getContext().getServiceReferences(clazz, null);
            services = new ArrayList<Object>();
            for (ServiceReference serviceReference : serviceReferences) {
                services.add(DataSourcesActivator.getContext().getService(serviceReference));
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return services;
    }

    public static IDialectSpecifier getInstance(String productName) {
        if (!registered) {
            DialectFactoryOSGi.registerDialectSpecifiers();
        }
        if (dialectSpecifiers != null) {
            for (IDialectSpecifier dialect : dialectSpecifiers) {
                if (!dialect.isDialectForName(productName)) continue;
                return dialect;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerDialectSpecifiers() {
        Class<DialectFactoryOSGi> clazz = DialectFactoryOSGi.class;
        synchronized (DialectFactoryOSGi.class) {
            dialectSpecifiers = DialectFactoryOSGi.getServices(IDialectSpecifier.class);
            registered = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

