/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.dirigible.repository.datasource.WrappedDataSource;
import org.eclipse.dirigible.repository.logging.Logger;

public class DataSourceFacade {
    private static final Logger logger = Logger.getLogger((String)DataSourceFacade.class.getCanonicalName());
    private static final int DEFAULT_MAX_WAIT = 10000;
    private static final int DEFAULT_MAX_IDLE = 30;
    private static final int DEFAULT_MAX_ACTIVE = 100;
    private static final String EMBEDDED_DATA_SOURCE_IS_USED = "Embedded DataSource is used! In case you intentionally use local datasource, ignore this error.";
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    private static final String LOCAL_DB_ROOT = "localDatabaseRootFolder";
    private static final String DATASOURCE_DEFAULT = "DEFAULT_DATASOURCE";
    private static final String DEFAULT_DATASOURCE_TYPE = "defaultDataSourceType";
    private static final String DEFAULT_DATASOURCE_TYPE_JNDI = "jndi";
    private static final String DEFAULT_DATASOURCE_TYPE_LOCAL = "local";
    private static final String JNDI_DEFAULT_DATASOURCE = "jndiDefaultDataSource";
    public static final String DATASOURCE_PREFIX = "DATASOURCE_";
    public static final String PARAM_DB_ID = "db.id";
    public static final String PARAM_DB_NAME = "db.name";
    public static final String PARAM_DB_TYPE = "db.type";
    public static final String PARAM_DB_LOC = "db.location";
    public static final String PARAM_DB_DRIVER = "db.driver";
    public static final String PARAM_DB_USER = "db.user";
    public static final String PARAM_DB_PASSWORD = "db.password";
    public static final String PARAM_DB_AUTO_COMMIT = "db.auto-commit";
    public static final String PARAM_DB_AUTO_MAX_ACTIVE = "db.max-active";
    public static final String PARAM_DB_AUTO_MAX_IDLE = "db.max-idle";
    public static final String PARAM_DB_AUTO_MAX_WAIT = "db.max-wait";
    public static final String PARAM_DB_TYPE_JNDI = "jndi";
    public static final String PARAM_DB_TYPE_DIRECT = "direct";
    private static final String DEFAULT_DATASOURCE_URL = "dataSourceDefaultUrl";
    private static final String DEFAULT_DATASOURCE_DRIVER = "dataSourceDefaultDriver";
    private static final String DEFAULT_DATASOURCE_USER = "dataSourceDefaultUser";
    private static final String DEFAULT_DATASOURCE_PASSWORD = "dataSourceDefaultPassword";
    private static final String DEFAULT_DATASOURCE_AUTO_COMMIT = "dataSourceDefaultAutoCommit";
    private static final String DEFAULT_DATASOURCE_MAX_ACTIVE = "dataSourceDefaultMaxActive";
    private static final String DEFAULT_DATASOURCE_MAX_IDLE = "dataSourceDefaultMaxIdle";
    private static final String DEFAULT_DATASOURCE_MAX_WAIT = "dataSourceDefaultMaxWait";
    private static final String DEFAULT_JNDI_NAME = "java:comp/env/jdbc/DefaultDB";
    private static DataSource localDataSource;
    private static DataSourceFacade instance;
    private WrappedDataSource dataSource;
    private static Map<String, Properties> namedDataSources;

    static {
        namedDataSources = Collections.synchronizedMap(new HashMap());
    }

    public static DataSourceFacade getInstance() {
        if (instance == null) {
            instance = new DataSourceFacade();
        }
        return instance;
    }

    public DataSource getDataSource(HttpServletRequest request) {
        if (this.dataSource == null) {
            logger.debug("Lookup or create a Datasource...");
            if (request == null) {
                logger.debug("No request - try from Env...");
                this.dataSource = this.getFromEnv();
            } else {
                logger.debug("Request exists - try from Request...");
                this.dataSource = this.getFromSession(request);
            }
            if (this.dataSource == null) {
                logger.debug("Try from Context...");
                String jndiName = DataSourceFacade.getEnv(JNDI_DEFAULT_DATASOURCE);
                if (jndiName == null) {
                    jndiName = DEFAULT_JNDI_NAME;
                }
                this.dataSource = (WrappedDataSource)this.getFromContext(jndiName, true);
                if (this.dataSource != null) {
                    logger.info("Datasource lookup from the context done.");
                }
            }
            if (this.dataSource == null) {
                logger.debug("Try Custom via Env...");
                this.dataSource = this.createFromEnv();
                if (this.dataSource != null) {
                    logger.info("Datasource creation from the env vars done.");
                }
            }
            if (this.dataSource == null) {
                try {
                    this.dataSource = this.createLocal();
                    logger.warn("Local DataSource creation done.");
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.dataSource;
    }

    protected WrappedDataSource createFromEnv() {
        String url = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_URL);
        String driver = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_DRIVER);
        String user = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_USER);
        String password = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_PASSWORD);
        String defaultAutoCommit = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_AUTO_COMMIT);
        String maxActive = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_MAX_ACTIVE);
        String maxIdle = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_MAX_IDLE);
        String maxWait = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_MAX_WAIT);
        if (url == null || driver == null) {
            return null;
        }
        this.dataSource = this.createCustomDataSource(url, driver, user, password, defaultAutoCommit, maxActive, maxIdle, maxWait);
        System.getProperties().put(DATASOURCE_DEFAULT, this.dataSource);
        return this.dataSource;
    }

    private WrappedDataSource getFromSession(HttpServletRequest request) {
        logger.debug("Try to get datasource from the Request");
        DataSource dataSource = null;
        dataSource = (DataSource)request.getAttribute(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from the Request");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in the Request");
        return null;
    }

    private WrappedDataSource getFromEnv() {
        logger.debug("Try to get datasource from System Properties");
        DataSource dataSource = null;
        dataSource = (DataSource)System.getProperties().get(DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            logger.debug("Datasource retrieved from System Properties");
            return wrappedDataSource;
        }
        logger.debug("Datasource NOT available in System Properties");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSource getFromContext(String jndiName, boolean wrap) {
        String defaultDataSourceType = DataSourceFacade.getEnv(DEFAULT_DATASOURCE_TYPE);
        if (defaultDataSourceType != null && !"jndi".equalsIgnoreCase(defaultDataSourceType)) {
            logger.warn("Default DataSource Type Parameter is not 'jndi', hence the custom or local type will be used");
            return null;
        }
        logger.debug("Try to get datasource from the InitialContext");
        try {
            DataSource datasource;
            InitialContext context = (InitialContext)System.getProperties().get("InitialContext");
            if (context == null || jndiName == null) {
                context = new InitialContext();
            }
            if ((datasource = (DataSource)context.lookup(jndiName)) == null) {
                logger.error("Could not find DataSource in Initial Context by name: " + jndiName);
                return null;
            }
            Connection con = null;
            try {
                try {
                    con = datasource.getConnection();
                }
                catch (Exception e) {
                    logger.error("Datasource retrieved from InitialContext, but it is broken - not bound to a real database", (Throwable)e);
                    if (con == null) return null;
                    con.close();
                    return null;
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
            if (wrap) {
                WrappedDataSource wrappedDataSource = new WrappedDataSource(datasource);
                logger.debug("Datasource retrieved from InitialContext and wrapped");
                return wrappedDataSource;
            }
            logger.debug("Datasource retrieved from InitialContext and returned unwrapped");
            return datasource;
        }
        catch (Throwable e) {
            logger.error("Could not find DataSource", e);
        }
        return null;
    }

    private WrappedDataSource createLocal() throws IOException {
        logger.debug("Try to create embedded datasource");
        localDataSource = (DataSource)System.getProperties().get(LOCAL_DB_NAME);
        if (localDataSource == null) {
            File rootFile;
            File parentFile;
            localDataSource = new EmbeddedDataSource();
            String derbyRoot = (String)System.getProperties().get(LOCAL_DB_ROOT);
            if (derbyRoot == null) {
                derbyRoot = LOCAL_DB_NAME;
            }
            if (!(parentFile = (rootFile = new File(derbyRoot)).getCanonicalFile().getParentFile()).exists()) {
                parentFile.mkdirs();
            }
            ((EmbeddedDataSource)localDataSource).setDatabaseName(derbyRoot);
            ((EmbeddedDataSource)localDataSource).setCreateDatabase(LOCAL_DB_ACTION);
            System.getProperties().put(LOCAL_DB_NAME, localDataSource);
            logger.warn(String.format("Embedded Derby at: %s", derbyRoot));
        }
        logger.warn(EMBEDDED_DATA_SOURCE_IS_USED);
        WrappedDataSource wrappedDataSource = new WrappedDataSource(localDataSource);
        return wrappedDataSource;
    }

    public void registerDataSource(String name, Properties namedDataSource) {
        namedDataSources.put(name, namedDataSource);
        logger.debug(String.format("Datasource with name %s has been registered", name));
    }

    public DataSource getNamedDataSource(HttpServletRequest request, String name) {
        Properties properties = namedDataSources.get(name);
        if (properties == null) {
            logger.error(String.format("Named DataSource %s is not configured in the Repository.", name));
            return null;
        }
        String id = properties.getProperty(PARAM_DB_ID);
        String type = properties.getProperty(PARAM_DB_TYPE);
        String loc = properties.getProperty(PARAM_DB_LOC);
        DataSource namedDataSource = null;
        if (request != null) {
            String nameInSession = DATASOURCE_PREFIX + id;
            namedDataSource = (DataSource)request.getAttribute(nameInSession);
            if (namedDataSource == null) {
                if ("jndi".equals(type)) {
                    namedDataSource = this.getFromContext(loc, false);
                    if (namedDataSource != null) {
                        request.setAttribute(nameInSession, (Object)namedDataSource);
                    } else {
                        logger.error(String.format("Named DataSource %s has not been injected in the request's session. Check the initial parameters.", nameInSession));
                    }
                } else if (PARAM_DB_TYPE_DIRECT.equals(type)) {
                    namedDataSource = this.createDirectDataSource(properties);
                    if (namedDataSource != null) {
                        request.setAttribute(nameInSession, (Object)namedDataSource);
                    } else {
                        logger.error(String.format("Named DataSource %s cannot be created based on the configurations metadata", nameInSession));
                    }
                }
            }
        } else {
            namedDataSource = this.getFromContext(loc, false);
        }
        return namedDataSource;
    }

    private DataSource createDirectDataSource(Properties properties) {
        properties.getProperty(PARAM_DB_ID);
        properties.getProperty(PARAM_DB_NAME);
        String url = properties.getProperty(PARAM_DB_LOC);
        String driver = properties.getProperty(PARAM_DB_DRIVER);
        String user = properties.getProperty(PARAM_DB_USER);
        String password = properties.getProperty(PARAM_DB_PASSWORD);
        String defaultAutoCommit = properties.getProperty(PARAM_DB_AUTO_COMMIT);
        String maxActive = properties.getProperty(PARAM_DB_AUTO_MAX_ACTIVE);
        String maxIdle = properties.getProperty(PARAM_DB_AUTO_MAX_IDLE);
        String maxWait = properties.getProperty(PARAM_DB_AUTO_MAX_WAIT);
        this.dataSource = this.createCustomDataSource(url, driver, user, password, defaultAutoCommit, maxActive, maxIdle, maxWait);
        return this.dataSource;
    }

    protected WrappedDataSource createCustomDataSource(String url, String driver, String user, String password, String defaultAutoCommit, String maxActive, String maxIdle, String maxWait) {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(driver);
        basicDataSource.setUrl(url);
        basicDataSource.setUsername(user);
        basicDataSource.setPassword(password);
        basicDataSource.setDefaultAutoCommit(Boolean.parseBoolean(defaultAutoCommit));
        basicDataSource.setMaxActive(maxActive != null ? Integer.parseInt(maxActive) : 100);
        basicDataSource.setMaxIdle(maxIdle != null ? Integer.parseInt(maxIdle) : 30);
        basicDataSource.setMaxWait((long)(maxWait != null ? Integer.parseInt(maxWait) : 10000));
        return new WrappedDataSource((DataSource)basicDataSource);
    }

    public Set<String> getNamedDataSourcesNames() {
        return namedDataSources.keySet();
    }

    public void unregisterDataSource(String name) {
        namedDataSources.remove(name);
    }

    public void unregisterAllDataSources() {
        namedDataSources.clear();
    }

    public Properties getNamedDataSourceConfig(String dsName) {
        return namedDataSources.get(dsName);
    }

    public static String getEnv(String name) {
        String var = System.getProperty(name);
        if (var == null) {
            var = System.getenv(name);
        }
        return var;
    }
}

