/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.security.publish;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.security.SecurityUpdater;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class SecurityPublisher
extends AbstractPublisher
implements IPublisher {
    private static final Logger logger = Logger.getLogger(SecurityPublisher.class);

    public void publish(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation(), request);
            IFolder sourceFolder = this.getSourceFolder(project, "SecurityConstraints");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
            ArrayList knownFiles = new ArrayList();
            SecurityUpdater securityUpdater = new SecurityUpdater(RepositoryFacade.getInstance().getRepository(request), DataSourceFacade.getInstance().getDataSource(request), this.getRegistryLocation());
            ICollection sourceProjectContainer = this.getSourceProjectContainer(project, request);
            ICollection sourceContainer = sourceProjectContainer.getCollection("SecurityConstraints");
            securityUpdater.enumerateKnownFiles(sourceContainer, knownFiles);
            ArrayList errors = new ArrayList();
            securityUpdater.executeUpdate(knownFiles, request, errors);
            if (errors.size() > 0) {
                throw new PublishException(CommonUtils.concatenateListOfStrings(errors, (String)"\n"));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project, HttpServletRequest request) throws PublishException {
        this.publish(project, request);
    }

    public void activateFile(IFile file, HttpServletRequest request) throws PublishException {
        this.publish(file.getProject(), request);
    }

    public String getFolderType() {
        return "SecurityConstraints";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && ".access".equals("." + file.getFileExtension());
    }

    public String getPublishedContainerMapping(IFile file) {
        return null;
    }

    public String getActivatedContainerMapping(IFile file) {
        return null;
    }

    public boolean isAutoActivationAllowed() {
        return false;
    }

    protected String getSandboxLocation(HttpServletRequest request) {
        return null;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/SecurityConstraints";
    }

    public void template(IProject project, HttpServletRequest request) throws PublishException {
    }
}

