/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.html.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateTitlePage;
import org.eclipse.dirigible.ide.template.ui.html.wizard.WikiTemplateTypePage;
import org.eclipse.jface.wizard.IWizardPage;

public class WikiTemplateWizard
extends TemplateWizard {
    private static final String CREATE_WIKI_PAGE = Messages.WikiTemplateWizard_CREATE_WIKI_PAGE;
    private final WikiTemplateModel model;
    private final WikiTemplateTypePage typesPage;
    private final WikiTemplateTargetLocationPage targetLocationPage;
    private final WikiTemplateTitlePage titlePage;

    public WikiTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_WIKI_PAGE);
        this.model = new WikiTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new WikiTemplateTypePage(this.model);
        this.targetLocationPage = new WikiTemplateTargetLocationPage(this.model);
        this.titlePage = new WikiTemplateTitlePage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.targetLocationPage);
        this.addPage((IWizardPage)this.titlePage);
    }

    public TemplateGenerator getTemplateGenerator() {
        WikiTemplateGenerator generator = new WikiTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

