/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.jgit.command.Messages;
import org.eclipse.dirigible.ide.jgit.command.ui.PushCommandDialog;
import org.eclipse.dirigible.ide.jgit.utils.CommandHandlerUtils;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PushCommandHandler
extends AbstractWorkspaceHandler {
    private static final String TASK_PUSHING_TO_REMOTE_REPOSITORY = Messages.PushCommandHandler_TASK_PUSHING_TO_REMOTE_REPOSITORY;
    private static final String PLEASE_MERGE_TO_MASTER_AND_THEN_CONTINUE_WORKING_ON_PROJECT = Messages.PushCommandHandler_PLEASE_MERGE_TO_MASTER_AND_THEN_CONTINUE_WORKING_ON_PROJECT;
    private static final String PUSHED_TO_REMOTE_BRANCH_S = Messages.PushCommandHandler_PUSHED_TO_REMOTE_BRANCH_S;
    private static final String PROJECT_HAS_D_CONFILCTING_FILES = Messages.PushCommandHandler_PROJECT_HAS_D_CONFILCTING_FILES;
    private static final String CONFLICTING_FILES = Messages.PushCommandHandler_CONFLICTING_FILES;
    private static final String THIS_IS_NOT_A_GIT_PROJECT = Messages.PushCommandHandler_THIS_IS_NOT_A_GIT_PROJECT;
    private static final String CHANGES_BRANCH = "changes_branch_";
    private static final String SLASH = "/";
    private static final String DOT_GIT = ".git";
    private static final String MASTER = "master";
    private static final String INCORRECT_USERNAME_AND_OR_PASSWORD_OR_GIT_REPOSITORY_URI = Messages.PushCommandHandler_INCORRECT_USERNAME_AND_OR_PASSWORD_OR_GIT_REPOSITORY_URI;
    private static final String PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY = Messages.PushCommandHandler_PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY;
    private static final String PLEASE_SELECT_ONE = Messages.PushCommandHandler_PLEASE_SELECT_ONE;
    private static final String ONLY_ONE_PROJECT_CAN_BE_PUSHED_AT_A_TIME = Messages.PushCommandHandler_ONLY_ONE_PROJECT_CAN_BE_PUSHED_AT_A_TIME;
    private static final String ERROR_DURING_PUSH = Messages.PushCommandHandler_ERROR_DURING_PUSH;
    private static final String WHILE_PUSHING_PROJECT_ERROR_OCCURED = Messages.PushCommandHandler_WHILE_PUSHING_PROJECT_ERROR_OCCURED;
    private static final String PROJECT_HAS_BEEN_PUSHED_TO_REMOTE_REPOSITORY = Messages.PushCommandHandler_PROJECT_HAS_BEEN_PUSHED_TO_REMOTE_REPOSITORY;
    private static final String NO_PROJECT_IS_SELECTED_FOR_PUSH = Messages.PushCommandHandler_NO_PROJECT_IS_SELECTED_FOR_PUSH;
    private static final Logger logger = Logger.getLogger(PushCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection.isEmpty()) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_PUSH);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_PUSH);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_PUSH, (String)PLEASE_SELECT_ONE);
            return null;
        }
        IProject[] projects = CommandHandlerUtils.getProjects(selection, logger);
        if (projects.length == 0) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_PUSH);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_PUSH);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_PUSH, (String)PLEASE_SELECT_ONE);
            return null;
        }
        if (projects.length > 1) {
            logger.warn(ONLY_ONE_PROJECT_CAN_BE_PUSHED_AT_A_TIME);
            StatusLineManagerUtil.setWarningMessage((String)ONLY_ONE_PROJECT_CAN_BE_PUSHED_AT_A_TIME);
            MessageDialog.openWarning(null, (String)ONLY_ONE_PROJECT_CAN_BE_PUSHED_AT_A_TIME, (String)PLEASE_SELECT_ONE);
            return null;
        }
        IProject selectedProject = projects[0];
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        monitor.beginTask(TASK_PUSHING_TO_REMOTE_REPOSITORY, -1);
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        PushCommandDialog pushCommandDialog = new PushCommandDialog(parent);
        switch (pushCommandDialog.open()) {
            case 0: {
                String commitMessage = pushCommandDialog.getCommitMessage();
                String username = pushCommandDialog.getUsername();
                String password = pushCommandDialog.getPassword();
                String email = pushCommandDialog.getEmail();
                this.pushProjectToGitRepository(selectedProject, commitMessage, username, email, password);
            }
        }
        monitor.done();
        return null;
    }

    /*
     * Exception decompiling
     */
    private void pushProjectToGitRepository(IProject selectedProject, String commitMessage, String username, String email, String password) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

