/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.editor.text.editor;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.dirigible.ide.editor.text.editor.IContentProvider;
import org.eclipse.dirigible.ide.editor.text.editor.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.ui.IEditorInput;

public class ContentProviderFactory {
    private static final String CANNOT_READ_CONTENT_PROVIDER_EXTENSION_CLASS_0_INPUT_TYPE_1 = Messages.ContentProviderFactory_CANNOT_READ_CONTENT_PROVIDER_EXTENSION_CLASS_0_INPUT_TYPE_1;
    private static final String UNSUPPORTED_I_EDITOR_INPUT = Messages.ContentProviderFactory_UNSUPPORTED_I_EDITOR_INPUT;
    private static final Logger LOGGER = Logger.getLogger(ContentProviderFactory.class);
    private static final String EXT_POINT_ID = "org.eclipse.dirigible.ide.editor.text.contentProviders";
    private static ContentProviderFactory INSTANCE;
    private Map<String, IContentProvider> contentProviders = new HashMap<String, IContentProvider>();

    private ContentProviderFactory() {
        this.readExtensions();
    }

    public static ContentProviderFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ContentProviderFactory();
        }
        return INSTANCE;
    }

    public IContentProvider getContentProvider(IEditorInput input) {
        String entryInputClassName;
        Class<?> inputClass = input.getClass();
        for (Map.Entry<String, IContentProvider> entry : this.contentProviders.entrySet()) {
            entryInputClassName = entry.getKey();
            if (!inputClass.getName().equals(entryInputClassName)) continue;
            return entry.getValue();
        }
        for (Map.Entry<String, IContentProvider> entry : this.contentProviders.entrySet()) {
            entryInputClassName = entry.getKey();
            if (!this.isInstanceOf(entryInputClassName, inputClass)) continue;
            return entry.getValue();
        }
        LOGGER.warn(String.valueOf(UNSUPPORTED_I_EDITOR_INPUT) + input.getClass().getCanonicalName());
        return null;
    }

    private boolean isInstanceOf(String objectClassName, Class clazz) {
        if (clazz.getName().equals(objectClassName)) {
            return true;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && this.isInstanceOf(objectClassName, superclass)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (this.isInstanceOf(objectClassName, intf)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void readExtensions() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor(EXT_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String inputType = configurationElement.getAttribute("inputTypes");
            try {
                this.contentProviders.put(inputType, (IContentProvider)configurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                String msg = MessageFormat.format(CANNOT_READ_CONTENT_PROVIDER_EXTENSION_CLASS_0_INPUT_TYPE_1, configurationElement.getAttribute("class"), inputType);
                LOGGER.error(msg, (Throwable)e);
            }
            ++n2;
        }
    }
}

