/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.cargo.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.cargo.core.CLIOption;
import org.eclipse.jface.preference.IPreferenceStore;

public class CargoTools {
    private CargoTools() {
        throw new IllegalStateException("Utility class");
    }

    public static List<CLIOption> getOptions(String subCommand) {
        try {
            Process process = CorrosionPlugin.getProcessForCommand(CargoTools.getCargoCommand(), subCommand, "--help");
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = in.readLine();
                while (line != null) {
                    if ("options:".equalsIgnoreCase(line)) break;
                    line = in.readLine();
                }
                if (line == null) {
                    return Collections.emptyList();
                }
                ArrayList<CLIOption> options = new ArrayList<CLIOption>();
                ArrayList<String> currentOptionLines = new ArrayList<String>();
                while (line != null) {
                    if (line.matches("\\s*")) break;
                    if (line.matches("\\s*-+.*")) {
                        if (!currentOptionLines.isEmpty()) {
                            options.add(new CLIOption(currentOptionLines));
                            currentOptionLines.clear();
                        }
                        currentOptionLines.add(line);
                    } else if (!currentOptionLines.isEmpty()) {
                        currentOptionLines.add(line);
                    }
                    line = in.readLine();
                }
                if (!currentOptionLines.isEmpty()) {
                    options.add(new CLIOption(currentOptionLines));
                    currentOptionLines.clear();
                }
                return options;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static String getCargoCommand() {
        IPreferenceStore store = CorrosionPlugin.getDefault().getPreferenceStore();
        return store.getString("corrosion.rustup_cargoPath");
    }

    public static void ensureDotCargoImportedAsProject(IProgressMonitor monitor) throws CoreException {
        File cargoFolder = new File(String.valueOf(System.getProperty("user.home")) + "/.cargo");
        if (!cargoFolder.exists()) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath location;
            IProject project = iProjectArray[n2];
            if (!project.isOpen() && project.getName().startsWith(".cargo")) {
                project.open(monitor);
            }
            if ((location = project.getLocation()) != null) {
                File projectFolder = location.toFile().getAbsoluteFile();
                if (cargoFolder.getAbsolutePath().startsWith(projectFolder.getAbsolutePath())) {
                    return;
                }
            }
            ++n2;
        }
        String projectName = ".cargo";
        while (workspace.getRoot().getProject(projectName).exists()) {
            projectName = String.valueOf(projectName) + '_';
        }
        IProjectDescription description = workspace.newProjectDescription(projectName);
        description.setLocation(Path.fromOSString((String)cargoFolder.getAbsolutePath()));
        IProject cargoProject = workspace.getRoot().getProject(projectName);
        cargoProject.create(description, monitor);
        cargoProject.open(monitor);
    }
}

