/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.refactoring.impl.EditorDocumentUndoChange;

public class EditorDocumentChange
extends TextChange {
    private long modificationStamp = -1L;
    private boolean doSave;
    private ITextEditor editor;
    private IDocument document;

    public EditorDocumentChange(String name, ITextEditor editor, boolean doSave) {
        super(name);
        this.editor = editor;
        this.doSave = doSave;
        this.document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
    }

    public Object getModifiedElement() {
        return this.document;
    }

    public ITextEditor getEditor() {
        return this.editor;
    }

    public boolean isDoSave() {
        return this.doSave;
    }

    public void setDoSave(boolean doSave) {
        this.doSave = doSave;
    }

    public void initializeValidationData(IProgressMonitor pm) {
        if (this.document instanceof IDocumentExtension4) {
            this.modificationStamp = ((IDocumentExtension4)this.document).getModificationStamp();
        }
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.document instanceof IDocumentExtension4 && ((IDocumentExtension4)this.document).getModificationStamp() != this.modificationStamp) {
            refactoringStatus.addFatalError("The content of the document has changed.");
        }
        return refactoringStatus;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        return this.document;
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.doSave) {
            this.editor.doSave(pm);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new EditorDocumentUndoChange(this.getName(), this.editor, edit, this.doSave);
    }
}

