/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSynonymTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.AbstractTypeReferenceVisitorWithParameter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public class RawTypeReferenceComputer
extends AbstractTypeReferenceVisitorWithParameter.InheritanceAware<Pair<Resource, Set<JvmType>>, JvmTypeReference> {
    private final TypesFactory factory;

    @Inject
    public RawTypeReferenceComputer(TypesFactory factory) {
        this.factory = factory;
    }

    public JvmTypeReference getRawTypeReference(JvmTypeReference reference, Resource resource) {
        JvmTypeReference result = (JvmTypeReference)this.visit(reference, Tuples.create((Object)resource, (Object)Sets.newHashSet()));
        return result;
    }

    @Override
    public JvmTypeReference doVisitTypeReference(JvmTypeReference reference, Pair<Resource, Set<JvmType>> context) {
        return reference;
    }

    @Override
    protected JvmTypeReference handleNullReference(Pair<Resource, Set<JvmType>> parameter) {
        return null;
    }

    @Override
    public JvmTypeReference doVisitCompoundTypeReference(JvmCompoundTypeReference reference, Pair<Resource, Set<JvmType>> context) {
        JvmCompoundTypeReference result = null;
        EList<JvmTypeReference> components = reference.getReferences();
        int recent = -1;
        for (int i = 0; i < components.size(); ++i) {
            JvmTypeReference component = (JvmTypeReference)components.get(i);
            JvmTypeReference rawType = (JvmTypeReference)this.visit(component, context);
            if (rawType == null || component == rawType) continue;
            if (result == null) {
                result = (JvmCompoundTypeReference)EcoreUtil.create((EClass)reference.eClass());
            }
            for (int j = recent + 1; j < i; ++j) {
                result.getReferences().add((Object)((JvmTypeReference)components.get(j)));
            }
            result.getReferences().add((Object)rawType);
            recent = i;
        }
        if (result != null) {
            return result;
        }
        return reference;
    }

    @Override
    public JvmTypeReference doVisitDelegateTypeReference(JvmDelegateTypeReference reference, Pair<Resource, Set<JvmType>> parameter) {
        JvmTypeReference result = (JvmTypeReference)super.doVisitDelegateTypeReference(reference, parameter);
        if (result == reference.getDelegate()) {
            return reference;
        }
        return result;
    }

    @Override
    public JvmTypeReference doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, Pair<Resource, Set<JvmType>> context) {
        JvmTypeReference rawComponentType;
        JvmTypeReference componentType = reference.getComponentType();
        if (componentType != (rawComponentType = (JvmTypeReference)this.visit(componentType, context))) {
            JvmGenericArrayTypeReference result = this.factory.createJvmGenericArrayTypeReference();
            result.setComponentType(rawComponentType);
            return result;
        }
        return reference;
    }

    @Override
    public JvmTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, Pair<Resource, Set<JvmType>> context) {
        JvmType type = reference.getType();
        if (type != null && !type.eIsProxy()) {
            if (type instanceof JvmTypeParameterDeclarator) {
                if (!((JvmTypeParameterDeclarator)((Object)type)).getTypeParameters().isEmpty()) {
                    JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
                    result.setType(type);
                    return result;
                }
            } else if (type instanceof JvmTypeParameter) {
                Set recursionGuard = (Set)context.getSecond();
                if (recursionGuard.add(type)) {
                    return this.getRawTypeFromConstraints((List<JvmTypeConstraint>)((JvmTypeParameter)type).getConstraints(), context);
                }
                return this.createObjectReference((Resource)context.getFirst());
            }
        }
        return reference;
    }

    @Override
    public JvmTypeReference doVisitWildcardTypeReference(JvmWildcardTypeReference reference, Pair<Resource, Set<JvmType>> context) {
        return this.getRawTypeFromConstraints((List<JvmTypeConstraint>)reference.getConstraints(), context);
    }

    protected JvmTypeReference getRawTypeFromConstraints(List<JvmTypeConstraint> constraints, Pair<Resource, Set<JvmType>> context) {
        if (!constraints.isEmpty()) {
            JvmTypeReference result = null;
            for (JvmTypeConstraint constraint : constraints) {
                JvmDelegateTypeReference delegate;
                JvmSynonymTypeReference synonym;
                if (!(constraint instanceof JvmUpperBound)) continue;
                JvmTypeReference rawType = (JvmTypeReference)this.visit(constraint.getTypeReference(), context);
                if (result == null) {
                    if (rawType != null && rawType.eContainer() != null) {
                        JvmDelegateTypeReference delegate2 = this.factory.createJvmDelegateTypeReference();
                        delegate2.setDelegate(rawType);
                        rawType = delegate2;
                    }
                    result = rawType;
                    continue;
                }
                if (!(result instanceof JvmSynonymTypeReference)) {
                    synonym = this.factory.createJvmSynonymTypeReference();
                    synonym.getReferences().add((Object)result);
                    if (rawType.eContainer() != null) {
                        delegate = this.factory.createJvmDelegateTypeReference();
                        delegate.setDelegate(rawType);
                        rawType = delegate;
                    }
                    synonym.getReferences().add((Object)rawType);
                    result = synonym;
                    continue;
                }
                synonym = (JvmSynonymTypeReference)result;
                if (rawType.eContainer() != null) {
                    delegate = this.factory.createJvmDelegateTypeReference();
                    delegate.setDelegate(rawType);
                    rawType = delegate;
                }
                synonym.getReferences().add((Object)rawType);
            }
            if (result != null) {
                return result;
            }
        }
        return this.createObjectReference((Resource)context.getFirst());
    }

    protected JvmTypeReference createObjectReference(Resource resource) {
        JvmType objectType = this.factory.createJvmGenericType();
        String objectClassName = Object.class.getName();
        ((InternalEObject)objectType).eSetProxyURI(URIHelperConstants.OBJECTS_URI.appendSegment(objectClassName).appendFragment(objectClassName));
        if (resource != null) {
            objectType = (JvmType)EcoreUtil.resolve((EObject)objectType, (Resource)resource);
        }
        JvmParameterizedTypeReference result = this.factory.createJvmParameterizedTypeReference();
        result.setType(objectType);
        return result;
    }
}

