/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.mixed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.transition.system2subsystem.tests.System2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.util.ChainHelper;

public class CycleOnMerge
extends System2SubsystemTest
implements System2SubsystemTest.Crossphase {
    public static final String FC2 = "bf929ddd-fa16-4be7-9961-2c1e2ef3e01c";
    public static final String PF2 = "7dde20f2-34c1-4e55-bfbb-736ade022ca6";
    public static final String PC_1 = "7f68434c-885a-4f5d-a47c-0282f639a7a9";

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("TestDoubleNext", "output");
    }

    @Override
    protected Collection<?> getProjectionElements() {
        return Collections.singleton(this.getObject(PC_1));
    }

    @Override
    protected void verify() {
        FunctionalChain fc = (FunctionalChain)this.mustBeTransitioned(FC2);
        AbstractFunction fct = (AbstractFunction)this.mustBeTransitioned(PF2);
        CycleOnMerge.assertTrue((boolean)FunctionalChainExt.isFunctionalChainValid((FunctionalChain)fc));
        List<FunctionalChainInvolvementLink> links = ChainHelper.referencingFakeExchanges(fc);
        CycleOnMerge.assertTrue((links.size() == 2 ? 1 : 0) != 0);
        long countInvolvmentsOfFunction = fc.getOwnedFunctionalChainInvolvements().stream().filter(x -> x instanceof FunctionalChainInvolvementFunction).map(FunctionalChainInvolvementFunction.class::cast).map(x -> x.getInvolved()).filter(x -> fct.equals(x)).count();
        CycleOnMerge.assertTrue((countInvolvmentsOfFunction == 2L ? 1 : 0) != 0);
    }
}

