/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.CompareElementsEditor;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ObjectComparison;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CompareObjectsAction
extends ObjectActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow fWindow;
    private static final String EDITOR_ID = "org.eclipse.jdt.debug.compareElementsEditor";

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    @Override
    protected IWorkbenchPart getPart() {
        IWorkbenchPart part = super.getPart();
        if (part != null) {
            return part;
        }
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActivePart();
        }
        return null;
    }

    public void run(IAction action) {
        ISelection selection;
        ISelectionProvider provider;
        if (this.getPart() != null && (provider = this.getPart().getSite().getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection selections = (IStructuredSelection)selection;
            this.compareSelectedObjects(selections.toList());
            return;
        }
    }

    protected void compareSelectedObjects(List<IStructuredSelection> selections) {
        ObjectComparison obcp = new ObjectComparison();
        Map<Object, Object> result = new HashMap();
        try {
            Set<String> valueSet = this.selectionTypeChecker(selections);
            if (valueSet.size() != 1) {
                this.displayComparisonFailure(DebugUIMessages.DifferentDataStructures);
                return;
            }
            String temp = (String)valueSet.toArray()[0];
            if (temp.equals("Lists")) {
                result = obcp.listExtraction(selections);
                result = obcp.compareSelectedLists(result, temp);
                if (selections.size() == 2) {
                    this.displayListResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Sets")) {
                result = obcp.setExtraction(selections);
                result = obcp.compareSelectedLists(result, temp);
                if (selections.size() == 2) {
                    this.displayListResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Queues") || temp.equals("Deques")) {
                result = obcp.listExtraction(selections);
                result = obcp.compareSelectedLists(result, temp);
                if (selections.size() == 2) {
                    this.displayListResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Maps")) {
                result = obcp.mapExtraction(selections);
                result = obcp.compareSelectedMaps(result);
                if (selections.size() == 2) {
                    this.displayMapResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Iterables")) {
                result = obcp.iterableExtraction(selections);
                result = obcp.compareSelectedLists(result, temp);
                if (selections.size() == 2) {
                    this.displayListResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Arrays")) {
                result = obcp.arrayExtraction(selections);
                result = obcp.compareSelectedLists(result, temp);
                if (selections.size() == 2) {
                    this.displayListResultsInDialogBox(result);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("CharSequences")) {
                result = obcp.stringExtraction(selections);
                result = obcp.stringCompare(result);
                if (selections.size() == 2) {
                    String type = temp.substring(temp.lastIndexOf(46) + 1);
                    this.displayComparisonResults(result, type);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else if (temp.equals("Wrappers")) {
                result = obcp.extractOtherObjects(selections);
                result = obcp.compareObjects(result);
                if (selections.size() == 2) {
                    String type = temp.substring(temp.lastIndexOf(46) + 1);
                    this.displayComparisonResults(result, type);
                    return;
                }
                this.displayInDiffView(result, temp);
            } else {
                result = obcp.customObjectsReferencesExtraction(selections);
                if (obcp.objectsRefCheck(result)) {
                    this.displayComparisonResults();
                    return;
                }
                result = obcp.extractCustomObjects(selections);
                result = obcp.compareCustomObjects(result);
                this.displayInDiffViewForComplex(result);
            }
        }
        catch (Exception e) {
            this.displayComparisonFailed(DebugUIMessages.CompareObjectsFailedException);
            DebugUIPlugin.log((Throwable)e);
            return;
        }
    }

    private String comparisonTypeCheck(IJavaVariable selectedObject) throws DebugException {
        String valueReferenceType = selectedObject.getValue().getReferenceTypeName();
        String declarationReferenceType = selectedObject.getReferenceTypeName();
        if (declarationReferenceType.endsWith("[]")) {
            return "Arrays";
        }
        String interfaceType = ObjectComparison.checkInterfaces(valueReferenceType);
        return interfaceType;
    }

    private Set<String> selectionTypeChecker(List<IStructuredSelection> selections) throws DebugException {
        HashMap<String, String> selectionTypeCheck = new HashMap<String, String>();
        for (IStructuredSelection selection : selections) {
            if (!(selection instanceof IJavaVariable)) continue;
            IJavaVariable selectedObject = (IJavaVariable)selection;
            String temp = this.comparisonTypeCheck(selectedObject);
            selectionTypeCheck.put(selectedObject.getName(), temp);
        }
        Set<String> valueSet = Set.copyOf(selectionTypeCheck.values());
        return valueSet;
    }

    private void displayInDiffView(Map<IJavaVariable, Object> result, String type) throws DebugException, PartInitException {
        ArrayList<Map<String, Object>> resultsList = new ArrayList<Map<String, Object>>();
        ArrayList<String> objectsName = new ArrayList<String>();
        for (Map.Entry<IJavaVariable, Object> mp : result.entrySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put(mp.getKey().getName(), mp.getValue());
            resultsList.add(temp);
            objectsName.add(mp.getKey().getName());
        }
        CompareElementsEditor cd = new CompareElementsEditor(resultsList, objectsName, type);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)cd, EDITOR_ID);
    }

    private void displayInDiffViewForComplex(Map<IJavaVariable, Object> result) throws DebugException, PartInitException {
        ArrayList<Map<String, Object>> resultsList = new ArrayList<Map<String, Object>>();
        ArrayList<String> objectsName = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        IJavaVariable javaVar = null;
        for (Map.Entry<IJavaVariable, Object> mp : result.entrySet()) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put(mp.getKey().getName(), mp.getValue());
            resultsList.add(temp);
            javaVar = mp.getKey();
            objectsName.add(mp.getKey().getName());
        }
        IVariable[] iVariableArray = javaVar.getValue().getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable x = iVariableArray[n2];
            fieldNames.add(x.getName());
            ++n2;
        }
        if (fieldNames.isEmpty()) {
            fieldNames.add(DebugUIMessages.CompareObjectsReference);
        }
        CompareElementsEditor cd = new CompareElementsEditor(resultsList, objectsName, "custom", fieldNames);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)cd, EDITOR_ID);
    }

    private void displayComparisonResults(Map<IJavaVariable, Object> result, String type) throws DebugException {
        ArrayList<IJavaVariable> selections = new ArrayList<IJavaVariable>();
        for (Map.Entry<IJavaVariable, Object> current : result.entrySet()) {
            IJavaVariable c = current.getKey();
            selections.add(c);
        }
        Map obj1 = (Map)result.get(selections.get(0));
        if (obj1.containsKey("ImmediateResult")) {
            String msg = obj1.get("ImmediateResult").toString();
            String message = msg.contains("Same") ? NLS.bind((String)DebugUIMessages.DialogBoxObjectsSame, (Object[])new Object[]{type}) : NLS.bind((String)DebugUIMessages.DialogBoxObjectsDifferent, (Object[])new Object[]{type});
            MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)message);
            return;
        }
        String message = NLS.bind((String)DebugUIMessages.CompareObjectsFailed, (Object[])new Object[]{type});
        MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_failed, (String)message);
    }

    private void displayComparisonResults() {
        String message = DebugUIMessages.ObjectsSame;
        MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)message);
    }

    private void displayListResultsInDialogBox(Map<IJavaVariable, Object> result) throws DebugException {
        List missingValues;
        String message;
        int displayLimit = 30;
        StringBuilder outputMessage = new StringBuilder();
        ArrayList<IJavaVariable> selections = new ArrayList<IJavaVariable>();
        for (Map.Entry<IJavaVariable, Object> current : result.entrySet()) {
            IJavaVariable c = current.getKey();
            selections.add(c);
        }
        Map obj1 = (Map)result.get(selections.get(0));
        Map obj2 = (Map)result.get(selections.get(1));
        String size1 = obj1.get("Element Size").toString();
        String size2 = obj2.get("Element Size").toString();
        if (obj1.get("ImmediateResult") != null || obj2.get("ImmediateResult") != null) {
            String msg = obj1.get("ImmediateResult").toString();
            if (msg.indexOf("as") != -1 && msg.indexOf(",") != -1) {
                String msgRemove = msg.substring(msg.indexOf("as") - 1, msg.indexOf(","));
                msg = msg.replace(msgRemove, "");
            }
            if (msg.contains("same as of") && msg.indexOf(",") == -1) {
                msg = NLS.bind((String)DebugUIMessages.ListSameElementsFor2, (Object[])new Object[]{msg.split(" ")[0]});
            }
            outputMessage.append(msg);
            MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)outputMessage.toString());
            return;
        }
        String selection1 = ((IJavaVariable)selections.get(0)).getName().toString();
        String selection2 = ((IJavaVariable)selections.get(1)).getName().toString();
        if (!size1.equals(size2)) {
            message = NLS.bind((String)DebugUIMessages.DialogBoxListItemCount, (Object[])new Object[]{selection1, size1});
            outputMessage.append(message + "\n");
            message = NLS.bind((String)DebugUIMessages.DialogBoxListItemCount, (Object[])new Object[]{selection2, size2});
            outputMessage.append(message);
        }
        if (obj1.containsKey("Values")) {
            missingValues = (List)obj1.get("Values");
            if (missingValues.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection1, missingValues, displayLimit));
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxListMissing, (Object[])new Object[]{selection1, missingValues.toString()});
                outputMessage.append("\n" + message);
            }
        }
        if (obj2.containsKey("Values")) {
            missingValues = (List)obj2.get("Values");
            if (missingValues.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection2, missingValues, displayLimit));
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxListMissing, (Object[])new Object[]{selection2, missingValues.toString()});
                outputMessage.append("\n" + message);
            }
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)outputMessage.toString());
    }

    private void displayMapResultsInDialogBox(Map<IJavaVariable, Object> result) throws DebugException {
        String message;
        List tempList;
        int displayLimit = 30;
        StringBuilder outputMessage = new StringBuilder();
        ArrayList<IJavaVariable> selections = new ArrayList<IJavaVariable>();
        for (Map.Entry<IJavaVariable, Object> current : result.entrySet()) {
            IJavaVariable c = current.getKey();
            selections.add(c);
        }
        Map obj1 = (Map)result.get(selections.get(0));
        Map obj2 = (Map)result.get(selections.get(1));
        String selection1 = ((IJavaVariable)selections.get(0)).getName().toString();
        String selection2 = ((IJavaVariable)selections.get(1)).getName().toString();
        if (obj1.containsKey("keySameInfo") && obj1.containsKey("valSameInfo") || obj2.containsKey("keySameInfo") && obj2.containsKey("valSameInfo")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)DebugUIMessages.DialogBoxMapSame);
            return;
        }
        if (obj1.containsKey("keySameInfo") || obj2.containsKey("keySameInfo")) {
            outputMessage.append(DebugUIMessages.DialogBoxMapKeySame + "\n");
        }
        if (obj1.containsKey("valSameInfo") || obj2.containsKey("valSameInfo")) {
            outputMessage.append(DebugUIMessages.DialogBoxMapValSame + "\n");
        }
        if (obj1.containsKey("MapValues")) {
            tempList = (List)obj1.get("MapValues");
            if (tempList.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection1, tempList, displayLimit) + "\n");
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxMapMissingVal, (Object[])new Object[]{selection1, tempList.toString()});
                outputMessage.append(message + "\n");
            }
        }
        if (obj2.containsKey("MapValues")) {
            tempList = (List)obj2.get("MapValues");
            if (tempList.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection2, tempList, displayLimit) + "\n");
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxMapMissingVal, (Object[])new Object[]{selection2, tempList.toString()});
                outputMessage.append(message + "\n");
            }
        }
        if (obj1.containsKey("MapKeys")) {
            tempList = (List)obj1.get("MapKeys");
            if (tempList.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection1, tempList, displayLimit) + "\n");
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxMapMissingKey, (Object[])new Object[]{selection1, tempList.toString()});
                outputMessage.append(message + "\n");
            }
        }
        if (obj2.containsKey("MapKeys")) {
            tempList = (List)obj2.get("MapKeys");
            if (tempList.size() > displayLimit) {
                outputMessage.append(this.printListContents(selection2, tempList, displayLimit) + "\n");
            } else {
                message = NLS.bind((String)DebugUIMessages.DialogBoxMapMissingKey, (Object[])new Object[]{selection2, tempList.toString()});
                outputMessage.append(message + "\n");
            }
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_long, (String)outputMessage.toString());
    }

    private String printListContents(String Selection, List<String> list, int displayLimit) {
        StringBuilder content = new StringBuilder();
        content.append("[");
        content.append(list.stream().limit(displayLimit).collect(Collectors.joining(",")));
        content.append("......]");
        String message = NLS.bind((String)DebugUIMessages.DialogBoxMapMissingKey, (Object[])new Object[]{Selection, content.toString()});
        return message;
    }

    private void displayComparisonFailed(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_failed, (String)message);
    }

    private void displayComparisonFailure(String message) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)DebugUIMessages.ObjectComparisonTitle_failed, (String)message);
    }

    protected Shell getShell() {
        if (this.fWindow != null) {
            return this.fWindow.getShell();
        }
        IWorkbenchWindow win = this.getWorkbenchWindow();
        if (win != null) {
            return win.getShell();
        }
        return null;
    }
}

