/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.Comparator;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ChoiceSetTest
extends BaseTestCase {
    private ChoiceSet choiceSet = null;
    private Choice[] choice = new Choice[3];

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.choiceSet = new ChoiceSet("ChoiceSetName");
        this.choice[0] = new Choice("ChoiceOneName", "ChoiceOne");
        this.choice[1] = new Choice("ChoiceTwoName", "ChoiceTwo");
        this.choice[2] = new Choice("ChoiceThreeName", "ChoiceThree");
    }

    public void testGetterAndSetter() {
        this.choiceSet.setChoices((IChoice[])this.choice);
        ChoiceSetTest.assertEquals((String)"ChoiceSetName", (String)this.choiceSet.getName());
        ChoiceSetTest.assertEquals((int)3, (int)this.choiceSet.getChoices().length);
        ChoiceSetTest.assertEquals((String)"ChoiceOneName", (String)this.choiceSet.findChoice("ChoiceOneName").getName());
        ChoiceSetTest.assertEquals((String)"ChoiceTwoName", (String)this.choiceSet.findChoice("ChoiceTwoName").getName());
        ChoiceSetTest.assertEquals((String)"ChoiceThreeName", (String)this.choiceSet.findChoice("ChoiceThreeName").getName());
        ChoiceSetTest.assertTrue((boolean)this.choiceSet.contains("ChoiceOneName"));
        ChoiceSetTest.assertTrue((boolean)this.choiceSet.contains("ChoiceTwoName"));
        ChoiceSetTest.assertTrue((boolean)this.choiceSet.contains("ChoiceThreeName"));
        ChoiceSetTest.assertFalse((boolean)this.choiceSet.contains("NotExisting"));
    }

    public void testGetChoices() {
        ChoiceSet choiceSet = new ChoiceSet();
        Choice[] choices = new Choice[]{new Choice("One", "value1"), new Choice("Two", "value2"), new Choice("Three", "value3")};
        choiceSet.setChoices((IChoice[])choices);
        IChoice[] internalChoices = choiceSet.getChoices();
        ChoiceSetTest.assertEquals((String)"One", (String)internalChoices[0].getName());
        ChoiceSetTest.assertEquals((String)"Two", (String)internalChoices[1].getName());
        ChoiceSetTest.assertEquals((String)"Three", (String)internalChoices[2].getName());
        IChoice[] naturedSortedChoices = choiceSet.getChoices(null);
        ChoiceSetTest.assertEquals((String)"One", (String)naturedSortedChoices[0].getName());
        ChoiceSetTest.assertEquals((String)"Three", (String)naturedSortedChoices[1].getName());
        ChoiceSetTest.assertEquals((String)"Two", (String)naturedSortedChoices[2].getName());
        IChoice[] sortedChoices = choiceSet.getChoices(new Comparator(){

            public int compare(Object o1, Object o2) {
                IChoice choice1 = (IChoice)o1;
                IChoice choice2 = (IChoice)o2;
                return choice2.getName().compareTo(choice1.getName());
            }
        });
        ChoiceSetTest.assertEquals((String)"Two", (String)sortedChoices[0].getName());
        ChoiceSetTest.assertEquals((String)"Three", (String)sortedChoices[1].getName());
        ChoiceSetTest.assertEquals((String)"One", (String)sortedChoices[2].getName());
    }

    public void testClone() throws Exception {
        this.choiceSet.setChoices((IChoice[])this.choice);
        ChoiceSet newChoiceSet = (ChoiceSet)this.choiceSet.clone();
        ChoiceSetTest.assertEquals((int)newChoiceSet.getChoices().length, (int)this.choiceSet.getChoices().length);
    }
}

