/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.editors;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.ui.IStorageEditorInput;

class ReportEditorStorageInput
extends ReportEditorInput
implements IStorageEditorInput {
    private static final ThreadLocal<Set<Class<?>>> COMPUTATION_IN_PROGRESS = new ThreadLocal<Set<Class<?>>>(){

        @Override
        protected Set<Class<?>> initialValue() {
            return new HashSet();
        }
    };

    public ReportEditorStorageInput(File file) {
        super(file);
    }

    public Object getAdapter(Class adapter) {
        Set<Class<?>> computationInProgress = COMPUTATION_IN_PROGRESS.get();
        if (!computationInProgress.contains(adapter)) {
            try {
                if (computationInProgress.add(adapter)) {
                    Object object = super.getAdapter(adapter);
                    return object;
                }
            }
            finally {
                computationInProgress.remove(adapter);
            }
        }
        return null;
    }
}

